/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.jei.common;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.ItemStack;

final class SlotUtil {
    private SlotUtil() {
    }

    static List<List<ItemResource>> getItems(IRecipeSlotsView recipeSlots, RecipeIngredientRole role) {
        return recipeSlots.getSlotViews(role).stream().map(SlotUtil::getItems).toList();
    }

    private static List<ItemResource> getItems(IRecipeSlotView slotView) {
        List<ItemStack> stacks = slotView.getItemStacks().collect(Collectors.toList());
        SlotUtil.prioritizeDisplayedStack(slotView, stacks);
        return stacks.stream().map(ItemResource::ofItemStack).collect(Collectors.toList());
    }

    private static void prioritizeDisplayedStack(IRecipeSlotView slotView, List<ItemStack> stacks) {
        slotView.getDisplayedItemStack().ifPresent(displayed -> {
            int index = stacks.indexOf(displayed);
            if (index < 0) {
                return;
            }
            stacks.remove(index);
            stacks.addFirst((ItemStack)displayed);
        });
    }

    static List<List<ResourceAmount>> getResources(IRecipeSlotsView recipeSlots, RecipeIngredientRole role) {
        return recipeSlots.getSlotViews(role).stream().map(SlotUtil::getResources).toList();
    }

    public static List<ResourceAmount> getResources(IRecipeSlotView slotView) {
        List<ResourceAmount> resources = slotView.getAllIngredients().flatMap(ingredient -> RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResourceAmount(ingredient.getIngredient()).stream()).collect(Collectors.toList());
        SlotUtil.prioritizeDisplayedIngredient(slotView, resources);
        return resources;
    }

    private static void prioritizeDisplayedIngredient(IRecipeSlotView slotView, List<ResourceAmount> resources) {
        slotView.getDisplayedIngredient().flatMap(displayed -> RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResourceAmount(displayed)).ifPresent(resourceAmount -> {
            int index = resources.indexOf(resourceAmount);
            if (index < 0) {
                return;
            }
            resources.remove(index);
            resources.addFirst((ResourceAmount)resourceAmount);
        });
    }
}

