/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.realtimers.ModuleFlowerRemover;

public class ModelLawnMower
extends ModelCartbase {
    private static final ArrayList<ModelPart> bladepins = new ArrayList();
    private static ModelPart leftSide;
    private static ModelPart rightSide;

    public ModelLawnMower() {
        super(null, ResourceHelper.getResource("/models/lawnmowerModel.png"));
        ModelLawnMower.genModel();
    }

    public static void genModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        leftSide = ModelLawnMower.createSide(partdefinition, false);
        rightSide = ModelLawnMower.createSide(partdefinition, true);
    }

    private static ModelPart createSide(PartDefinition partDefinition, boolean opposite) {
        PartDefinition anchor = partDefinition.addOrReplaceChild("anchor", CubeListBuilder.create(), PartPose.rotation((float)0.0f, (float)(opposite ? (float)Math.PI : 0.0f), (float)0.0f));
        PartDefinition base = anchor.addOrReplaceChild("base", CubeListBuilder.create().addBox(-11.5f, -3.0f, -1.0f, 23.0f, 6.0f, 2.0f), PartPose.offset((float)0.0f, (float)-1.5f, (float)-9.0f));
        for (int i = 0; i < 2; ++i) {
            PartDefinition arm = base.addOrReplaceChild("arm" + i, CubeListBuilder.create().texOffs(0, 8).addBox(-8.0f, -1.5f, -1.5f, 16.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)(-8.25f + (float)i * 16.5f), (float)0.0f, (float)-8.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
            PartDefinition arm2 = arm.addOrReplaceChild("arm2" + i, CubeListBuilder.create().texOffs(0, 14).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)6.5f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707964f));
            PartDefinition bladePin = arm2.addOrReplaceChild("bladepin" + i, CubeListBuilder.create().texOffs(0, 20).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f), PartPose.offset((float)2.5f, (float)0.0f, (float)0.0f));
            PartDefinition bladeAnchor = bladePin.addOrReplaceChild("bladeanchor" + i, CubeListBuilder.create(), PartPose.rotation((float)0.0f, (float)1.5707964f, (float)0.0f));
            for (int j = 0; j < 4; ++j) {
                PartDefinition blade = bladeAnchor.addOrReplaceChild("blade" + j, CubeListBuilder.create().texOffs(0, 22).addBox(-1.5f, -1.5f, -0.5f, 8.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)((float)j * 0.01f), (float)0.0f, (float)0.0f, (float)(1.5707964f * ((float)j + (float)i * 0.5f))));
                PartDefinition partDefinition2 = blade.addOrReplaceChild("bladetip" + j, CubeListBuilder.create().texOffs(0, 26).addBox(6.5f, -1.0f, -0.5f, 6.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.005f));
            }
        }
        ModelPart anchorPart = anchor.bake(64, 32);
        ModelPart basePart = anchorPart.getChild("base");
        for (int i = 0; i < 2; ++i) {
            ModelPart armPart = basePart.getChild("arm" + i);
            ModelPart arm2Part = armPart.getChild("arm2" + i);
            ModelPart bladePinPart = arm2Part.getChild("bladepin" + i);
            bladepins.add(bladePinPart);
        }
        return anchorPart;
    }

    @Override
    public void applyEffects(ModuleBase module, PoseStack matrixStack, MultiBufferSource rtb, float yaw, float pitch, float roll) {
        ModelLawnMower.genModel();
        boolean partialtime = false;
        float angle = module == null ? 0.0f : ((ModuleFlowerRemover)module).getBladeAngle() + (float)partialtime * ((ModuleFlowerRemover)module).getBladeSpeed();
        for (int i = 0; i < bladepins.size(); ++i) {
            ModelPart bladepin = bladepins.get(i);
            bladepin.xRot = i % 2 == 0 ? angle : -angle;
        }
    }

    @Override
    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumers, int light, int overlay, int colour) {
        leftSide.render(poseStack, vertexConsumers, light, overlay, colour);
        rightSide.render(poseStack, vertexConsumers, light, overlay, colour);
    }
}

