/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.containers.ContainerLiquid;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.storages.ITankHolder;
import vswe.stevescarts.helpers.storages.SCTank;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.helpers.storages.TransferManager;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.modules.storages.tanks.ModuleTank;
import vswe.stevescarts.network.packets.PacketFluidSync;

public class TileEntityLiquid
extends TileEntityManager
implements ITankHolder,
MenuProvider {
    public SCTank[] tanks;
    private int tick;
    private static final int[] topSlots = new int[]{0, 3, 6, 9};
    private static final int[] botSlots = new int[]{1, 4, 7, 10};
    private static final int[] sideSlots = new int[0];
    protected final SimpleContainerData dataAccess = new SimpleContainerData(17){

        public int get(int id) {
            return switch (id) {
                case 0 -> TileEntityLiquid.this.layoutType;
                case 1 -> TileEntityLiquid.this.color[0];
                case 2 -> TileEntityLiquid.this.color[1];
                case 3 -> TileEntityLiquid.this.color[2];
                case 4 -> TileEntityLiquid.this.color[3];
                case 5 -> {
                    if (TileEntityLiquid.this.toCart[0]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 6 -> {
                    if (TileEntityLiquid.this.toCart[1]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 7 -> {
                    if (TileEntityLiquid.this.toCart[2]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 8 -> {
                    if (TileEntityLiquid.this.toCart[3]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 9 -> {
                    if (TileEntityLiquid.this.doReturn[0]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 10 -> {
                    if (TileEntityLiquid.this.doReturn[1]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 11 -> {
                    if (TileEntityLiquid.this.doReturn[2]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 12 -> {
                    if (TileEntityLiquid.this.doReturn[3]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 13 -> TileEntityLiquid.this.amount[0];
                case 14 -> TileEntityLiquid.this.amount[1];
                case 15 -> TileEntityLiquid.this.amount[2];
                case 16 -> TileEntityLiquid.this.amount[3];
                default -> throw new IllegalArgumentException("Invalid index: " + id);
            };
        }

        public void set(int p_221477_1_, int p_221477_2_) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }
    };

    public TileEntityLiquid(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.LIQUID_MANAGER_TILE.get(), blockPos, blockState);
        this.tanks = new SCTank[4];
        for (int i = 0; i < 4; ++i) {
            this.tanks[i] = new SCTank(this, 32000, i);
        }
    }

    public SCTank[] getTanks() {
        return this.tanks;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level == null) {
            return;
        }
        if (this.tick-- <= 0) {
            this.tick = 5;
            if (!this.level.isClientSide) {
                for (int i = 0; i < 4; ++i) {
                    this.tanks[i].containerTransfer();
                }
            }
        }
    }

    public void syncTanks() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.getTanks() != null) {
            for (int i = 0; i < this.getTanks().length; ++i) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new PacketFluidSync(this.getTanks()[i].getFluid(), this.getBlockPos(), i), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    protected boolean isTargetValid(TransferManager p0) {
        return true;
    }

    @Override
    public int getContainerSize() {
        return 12;
    }

    @Override
    @Nonnull
    public ItemStack getInputContainer(int tankid) {
        return this.getItem(tankid * 3);
    }

    @Override
    public void setInputContainer(int tankid, ItemStack stack) {
        this.setItem(tankid * 3, stack);
    }

    @Override
    public void addToOutputContainer(int tankid, @Nonnull ItemStack item) {
        TransferHandler.TransferItem(item, this, tankid * 3 + 1, tankid * 3 + 1, new ContainerLiquid(0, null, this, new SimpleContainerData(17)), Slot.class, null, -1);
    }

    @Override
    public void onFluidUpdated(int tankid) {
        this.setChanged();
        this.syncTanks();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(GuiGraphics guiGraphics, int tankid, AbstractContainerScreen<?> gui, TextureAtlasSprite sprite, int targetX, int targetY, int width, int height) {
        guiGraphics.blit(targetX, targetY, 0, width, height, sprite);
    }

    @Override
    protected boolean doTransfer(TransferManager transfer) {
        int maximumToTransfer = this.hasMaxAmount(transfer.getSetting()) ? Math.min(this.getMaxAmount(transfer.getSetting()) - transfer.getWorkload(), 1000) : 1000;
        boolean sucess = false;
        if (this.toCart[transfer.getSetting()]) {
            boolean allFull = true;
            for (int i = 0; i < this.tanks.length; ++i) {
                int n = this.fillTank(transfer.getCart(), i, transfer.getSetting(), maximumToTransfer, IFluidHandler.FluidAction.SIMULATE);
                if (n <= 0) continue;
                this.fillTank(transfer.getCart(), i, transfer.getSetting(), n, IFluidHandler.FluidAction.EXECUTE);
                sucess = true;
                if (n >= maximumToTransfer) {
                    allFull = false;
                }
                if (!this.hasMaxAmount(transfer.getSetting())) break;
                transfer.setWorkload(transfer.getWorkload() + n);
                break;
            }
            if (allFull) {
                return false;
            }
        } else {
            ArrayList<ModuleTank> cartTanks = transfer.getCart().getModuleTanks();
            for (IFluidTank iFluidTank : cartTanks) {
                int drain = this.drainTank(iFluidTank, transfer.getSetting(), maximumToTransfer, IFluidHandler.FluidAction.SIMULATE);
                if (drain <= 0) continue;
                this.drainTank(iFluidTank, transfer.getSetting(), drain, IFluidHandler.FluidAction.EXECUTE);
                sucess = true;
                if (!this.hasMaxAmount(transfer.getSetting())) break;
                transfer.setWorkload(transfer.getWorkload() + drain);
                break;
            }
        }
        if (sucess && this.hasMaxAmount(transfer.getSetting()) && transfer.getWorkload() == this.getMaxAmount(transfer.getSetting())) {
            transfer.setLowestSetting(transfer.getSetting() + 1);
        }
        return sucess;
    }

    private int fillTank(EntityMinecartModular cart, int tankId, int sideId, int fillAmount, IFluidHandler.FluidAction doFill) {
        if (this.isTankValid(tankId, sideId)) {
            FluidStack fluidToFill = this.tanks[tankId].drain(fillAmount, doFill);
            if (fluidToFill.isEmpty()) {
                return 0;
            }
            fillAmount = fluidToFill.getAmount();
            if (this.isFluidValid(sideId, fluidToFill)) {
                ArrayList<ModuleTank> cartTanks = cart.getModuleTanks();
                for (IFluidTank iFluidTank : cartTanks) {
                    fluidToFill.shrink(iFluidTank.fill(fluidToFill, doFill));
                    if (fluidToFill.getAmount() > 0) continue;
                    return fillAmount;
                }
                this.syncTanks();
                return fillAmount - fluidToFill.getAmount();
            }
        }
        return 0;
    }

    private int drainTank(IFluidTank cartTank, int sideId, int drainAmount, IFluidHandler.FluidAction doDrain) {
        FluidStack drainedFluid = cartTank.drain(drainAmount, doDrain);
        if (drainedFluid.isEmpty()) {
            return 0;
        }
        drainAmount = drainedFluid.getAmount();
        if (this.isFluidValid(sideId, drainedFluid)) {
            for (int i = 0; i < this.tanks.length; ++i) {
                SCTank tank = this.tanks[i];
                if (!this.isTankValid(i, sideId)) continue;
                drainedFluid.shrink(tank.fill(drainedFluid, doDrain));
                if (drainedFluid.getAmount() > 0) continue;
                return drainAmount;
            }
            return drainAmount - drainedFluid.getAmount();
        }
        return 0;
    }

    private boolean isTankValid(int tankId, int sideId) {
        return !(this.layoutType == 1 && tankId != sideId || this.layoutType == 2 && this.color[sideId] != this.color[tankId]);
    }

    private boolean isTankValid(int tankId, Direction facing) {
        if (facing == null) {
            return false;
        }
        return switch (this.layoutType) {
            case 0 -> true;
            case 1 -> {
                if (tankId == this.facingToTankId(facing)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.color[tankId] == this.facingToColorId(facing)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean isFluidValid(int sideId, FluidStack fluid) {
        ItemStack filter = this.getItem(sideId * 3 + 2);
        FluidStack filterFluid = FluidUtil.getFluidContained((ItemStack)filter).orElse(FluidStack.EMPTY);
        return filterFluid.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)filterFluid, (FluidStack)fluid);
    }

    public int getMaxAmount(int id) {
        return (int)(this.getMaxAmountBuckets(id) * 1000.0f);
    }

    public float getMaxAmountBuckets(int id) {
        return switch (this.getAmountId(id)) {
            case 1 -> 0.25f;
            case 2 -> 0.5f;
            case 3 -> 0.75f;
            case 4 -> 1.0f;
            case 5 -> 2.0f;
            case 6 -> 3.0f;
            case 7 -> 5.0f;
            case 8 -> 7.5f;
            case 9 -> 10.0f;
            case 10 -> 15.0f;
            default -> 0.0f;
        };
    }

    public boolean hasMaxAmount(int id) {
        return this.getAmountId(id) != 0;
    }

    @Override
    public int getAmountCount() {
        return 11;
    }

    @Override
    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].setFluid(FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compoundTag.getCompound("Fluid" + i)));
        }
        this.setWorkload(compoundTag.getShort("workload"));
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        for (int i = 0; i < 4; ++i) {
            if (this.tanks[i].getFluid().isEmpty()) continue;
            CompoundTag compound = new CompoundTag();
            this.tanks[i].getFluid().save(provider, (Tag)compound);
            compoundTag.put("Fluid" + i, (Tag)compound);
        }
        compoundTag.putShort("workload", (short)this.getWorkload());
    }

    private boolean isInput(int id) {
        return id % 3 == 0;
    }

    private boolean isOutput(int id) {
        return id % 3 == 1;
    }

    public SCTank getValidTank(Direction facing) {
        for (int i = 0; i < this.getTanks().length; ++i) {
            if (!this.isTankValid(i, facing)) continue;
            return this.getTanks()[i];
        }
        return null;
    }

    private int facingToColorId(Direction facing) {
        return switch (facing.ordinal()) {
            case 2 -> 3;
            case 3 -> 2;
            case 4 -> 4;
            case 5 -> 1;
            default -> 1;
        };
    }

    private int facingToTankId(Direction facing) {
        return switch (facing.ordinal()) {
            case 2 -> 2;
            case 3 -> 1;
            case 4 -> 3;
            case 5 -> 0;
            default -> 0;
        };
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.liquidmanager");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
        if (this.level != null && !this.level.isClientSide) {
            this.syncTanks();
        }
        return new ContainerLiquid(id, playerInventory, this, this.dataAccess);
    }

    public boolean stillValid(@NotNull Player playerEntity) {
        return true;
    }
}

