/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.monopoly;

import java.util.EnumSet;
import net.minecraft.client.gui.GuiGraphics;
import vswe.stevescarts.arcade.monopoly.ArcadeMonopoly;
import vswe.stevescarts.arcade.monopoly.Note;
import vswe.stevescarts.arcade.monopoly.Piece;
import vswe.stevescarts.arcade.monopoly.Place;
import vswe.stevescarts.arcade.monopoly.PropertyGroup;
import vswe.stevescarts.client.guis.GuiMinecart;

public abstract class Property
extends Place {
    private String name;
    private int cost;
    private Piece owner;
    private PropertyGroup group;
    private boolean mortgaged;

    public Property(ArcadeMonopoly game, PropertyGroup group, String name, int cost) {
        super(game);
        this.group = group;
        this.group.add(this);
        this.name = name;
        this.cost = cost;
    }

    public void drawValue(GuiGraphics guiGraphics, GuiMinecart gui) {
        Note.drawValue(guiGraphics, this.game, gui, 10, 103, 2, this.cost);
    }

    @Override
    public void drawText(GuiGraphics guiGraphics, GuiMinecart gui, EnumSet<Place.PLACE_STATE> states) {
        this.game.getModule().drawSplitString(guiGraphics, gui, this.name, 3 + gui.getGuiLeft(), this.getTextY() + gui.getGuiTop(), 70, true, 0x404040);
    }

    protected abstract int getTextY();

    public int getCost() {
        return this.cost;
    }

    public void setOwner(Piece val) {
        this.owner = val;
    }

    public Piece getOwner() {
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    @Override
    public boolean onPieceStop(Piece piece) {
        return this.owner == null || this.owner == piece || this.mortgaged;
    }

    public PropertyGroup getGroup() {
        return this.group;
    }

    public abstract int getRentCost();

    public int getMortgageValue() {
        return this.getCost() / 2;
    }

    public int getOwnedInGroup() {
        int owned = 0;
        for (Property property : this.getGroup().getProperties()) {
            if (property.getOwner() != this.getOwner() || property.isMortgaged()) continue;
            ++owned;
        }
        return owned;
    }

    public boolean isMortgaged() {
        return this.mortgaged;
    }

    public boolean canMortgage() {
        return true;
    }

    public void mortgage() {
        this.mortgaged = true;
    }

    public int getUnMortgagePrice() {
        return (int)((float)this.getMortgageValue() * 1.1f);
    }

    public void unMortgage() {
        this.mortgaged = false;
    }
}

