/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client.security;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PacketSyncSecurity(UUID playerUUID, String playerUsername, @Nullable SecurityData securityData) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketSyncSecurity> TYPE = new CustomPacketPayload.Type(Mekanism.rl("sync_security"));
    public static final StreamCodec<ByteBuf, PacketSyncSecurity> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, PacketSyncSecurity::playerUUID, (StreamCodec)ByteBufCodecs.stringUtf8((int)PacketUtils.LAST_USERNAME_LENGTH), PacketSyncSecurity::playerUsername, (StreamCodec)ByteBufCodecs.optional(SecurityData.STREAM_CODEC), packet -> Optional.ofNullable(packet.securityData), (uuid, name, data) -> new PacketSyncSecurity((UUID)uuid, (String)name, data.orElse(null)));

    public PacketSyncSecurity(SecurityFrequency frequency) {
        this(frequency.getOwner(), frequency.getOwnerName(), new SecurityData(frequency));
    }

    public PacketSyncSecurity(UUID uuid) {
        this(uuid, MekanismUtils.getLastKnownUsername(uuid), null);
    }

    @NotNull
    public CustomPacketPayload.Type<PacketSyncSecurity> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        MekanismClient.clientUUIDMap.put(this.playerUUID, this.playerUsername);
        if (this.securityData != null) {
            MekanismClient.clientSecurityMap.put(this.playerUUID, this.securityData);
        }
    }
}

