/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import mekanism.client.gui.GuiUtils;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.integration.lookingat.ILookingAtElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookingAtElement
implements ILookingAtElement,
IFancyFontRenderer {
    private final int borderColor;
    private final int textColor;

    protected LookingAtElement(int borderColor, int textColor) {
        this.borderColor = borderColor;
        this.textColor = textColor;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int x, int y) {
        int scale;
        int width = this.getWidth();
        int height = this.getHeight();
        guiGraphics.fill(x, y, x + width - 1, y + 1, this.borderColor);
        guiGraphics.fill(x, y, x + 1, y + height - 1, this.borderColor);
        guiGraphics.fill(x + width - 1, y, x + width, y + height - 1, this.borderColor);
        guiGraphics.fill(x, y + height - 1, x + width, y + height, this.borderColor);
        TextureAtlasSprite icon = this.getIcon();
        if (icon != null && (scale = this.getScaledLevel(width - 2)) > 0) {
            boolean colored = this.applyRenderColor(guiGraphics);
            GuiUtils.drawTiledSprite(guiGraphics, x + 1, y + 1, height - 2, scale, height - 2, icon, 16, 16, 0, GuiUtils.TilingDirection.DOWN_RIGHT);
            if (colored) {
                MekanismRenderer.resetColor(guiGraphics);
            }
        }
        this.drawScrollingString(guiGraphics, this.getText(), x, y + 3, IFancyFontRenderer.TextAlignment.LEFT, this.textColor, 4, false);
    }

    public int getWidth() {
        return 100;
    }

    @Override
    public int getXSize() {
        return this.getWidth();
    }

    public int getHeight() {
        return 13;
    }

    public abstract int getScaledLevel(int var1);

    @Nullable
    public abstract TextureAtlasSprite getIcon();

    public abstract Component getText();

    protected boolean applyRenderColor(GuiGraphics guiGraphics) {
        return false;
    }
}

