/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.capabilities.MultiTypeCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IEnergyCompat {
    public boolean isUsable();

    default public boolean capabilityExists() {
        return true;
    }

    public MultiTypeCapability<?> getCapability();

    public <OBJECT, CONTEXT> ICapabilityProvider<OBJECT, CONTEXT, ?> getProviderAs(ICapabilityProvider<OBJECT, CONTEXT, IStrictEnergyHandler> var1);

    public Object wrapStrictEnergyHandler(IStrictEnergyHandler var1);

    @Nullable
    public IStrictEnergyHandler wrapAsStrictEnergyHandler(Object var1);

    @Nullable
    default public IStrictEnergyHandler getAsStrictEnergyHandler(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity tile, @Nullable Direction context) {
        Object capability = this.getCapability().getCapabilityIfLoaded(level, pos, state, tile, context);
        return capability == null ? null : this.wrapAsStrictEnergyHandler(capability);
    }

    @Nullable
    default public IStrictEnergyHandler getStrictEnergyHandler(ItemStack stack) {
        Object capability = this.getCapability().getCapability(stack);
        return capability == null ? null : this.wrapAsStrictEnergyHandler(capability);
    }

    @Nullable
    default public IStrictEnergyHandler getStrictEnergyHandler(Entity entity) {
        Object capability = this.getCapability().getCapability(entity);
        return capability == null ? null : this.wrapAsStrictEnergyHandler(capability);
    }
}

