/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.fluid;

import java.util.function.Supplier;
import mekanism.api.RelativeSide;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.holder.fluid.ConfigFluidTankHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;

public class FluidTankHelper {
    private final IFluidTankHolder slotHolder;
    private boolean built;

    private FluidTankHelper(IFluidTankHolder slotHolder) {
        this.slotHolder = slotHolder;
    }

    public static FluidTankHelper forSide(Supplier<Direction> facingSupplier) {
        return new FluidTankHelper(new FluidTankHolder(facingSupplier));
    }

    public static FluidTankHelper forSideWithConfig(ISideConfiguration sideConfiguration) {
        return new FluidTankHelper(new ConfigFluidTankHolder(sideConfiguration));
    }

    public <TANK extends IExtendedFluidTank> TANK addTank(@NotNull TANK tank) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IFluidTankHolder iFluidTankHolder = this.slotHolder;
        if (iFluidTankHolder instanceof FluidTankHolder) {
            FluidTankHolder slotHolder = (FluidTankHolder)iFluidTankHolder;
            slotHolder.addTank(tank, new RelativeSide[0]);
        } else {
            iFluidTankHolder = this.slotHolder;
            if (iFluidTankHolder instanceof ConfigFluidTankHolder) {
                ConfigFluidTankHolder slotHolder = (ConfigFluidTankHolder)iFluidTankHolder;
                slotHolder.addTank(tank);
            } else {
                throw new IllegalArgumentException("Holder does not know how to add tanks");
            }
        }
        return tank;
    }

    public <TANK extends IExtendedFluidTank> TANK addTank(@NotNull TANK tank, RelativeSide ... sides) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IFluidTankHolder iFluidTankHolder = this.slotHolder;
        if (!(iFluidTankHolder instanceof FluidTankHolder)) {
            throw new IllegalArgumentException("Holder does not know how to add tanks on specific sides");
        }
        FluidTankHolder slotHolder = (FluidTankHolder)iFluidTankHolder;
        slotHolder.addTank(tank, sides);
        return tank;
    }

    public IFluidTankHolder build() {
        this.built = true;
        return this.slotHolder;
    }
}

