/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import mekanism.api.Upgrade;
import mekanism.client.sound.FlamethrowerSoundActive;
import mekanism.client.sound.FlamethrowerSoundIdle;
import mekanism.client.sound.GeigerSound;
import mekanism.client.sound.GravitationalModulationSound;
import mekanism.client.sound.JetpackSound;
import mekanism.client.sound.PlayerSound;
import mekanism.client.sound.ScubaMaskSound;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.RadiationScale;
import mekanism.common.registration.impl.SoundEventRegistryObject;
import mekanism.common.tile.interfaces.ITileSound;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;
import net.neoforged.neoforge.client.event.sound.SoundEngineLoadEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="mekanism", value={Dist.CLIENT})
public class SoundHandler {
    private static final Map<UUID, PlayerSound> jetpackSounds = new Object2ObjectOpenHashMap();
    private static final Map<UUID, PlayerSound> scubaMaskSounds = new Object2ObjectOpenHashMap();
    private static final Map<UUID, PlayerSound[]> flamethrowerSounds = new Object2ObjectOpenHashMap();
    private static final Map<UUID, PlayerSound> gravitationalModulationSounds = new Object2ObjectOpenHashMap();
    public static final Map<RadiationScale, GeigerSound> radiationSoundMap = new EnumMap<RadiationScale, GeigerSound>(RadiationScale.class);
    private static final Long2ObjectMap<SoundInstance> soundMap = new Long2ObjectOpenHashMap();
    private static boolean IN_MUFFLED_CHECK = false;
    private static SoundEngine soundEngine;
    private static boolean hadPlayerSounds;

    private SoundHandler() {
    }

    public static void clearPlayerSounds() {
        jetpackSounds.clear();
        scubaMaskSounds.clear();
        flamethrowerSounds.clear();
        gravitationalModulationSounds.clear();
    }

    public static void clearPlayerSounds(UUID uuid) {
        jetpackSounds.remove(uuid);
        scubaMaskSounds.remove(uuid);
        flamethrowerSounds.remove(uuid);
        gravitationalModulationSounds.remove(uuid);
    }

    public static void startSound(@NotNull LevelAccessor world, @NotNull UUID uuid, @NotNull PlayerSound.SoundType soundType) {
        switch (soundType) {
            case JETPACK: {
                SoundHandler.startSound(world, uuid, jetpackSounds, JetpackSound::new);
                break;
            }
            case SCUBA_MASK: {
                SoundHandler.startSound(world, uuid, scubaMaskSounds, ScubaMaskSound::new);
                break;
            }
            case GRAVITATIONAL_MODULATOR: {
                SoundHandler.startSound(world, uuid, gravitationalModulationSounds, GravitationalModulationSound::new);
            }
        }
    }

    public static void startFlamethrowerSound(@NotNull Player player) {
        SoundHandler.startSounds(player, flamethrowerSounds, FlamethrowerSoundActive::new, FlamethrowerSoundIdle::new);
    }

    private static void startSound(LevelAccessor world, UUID uuid, Map<UUID, PlayerSound> knownSounds, Function<Player, PlayerSound> soundCreator) {
        if (knownSounds.containsKey(uuid)) {
            if (SoundHandler.playerSoundsEnabled()) {
                SoundHandler.restartSounds(knownSounds.get(uuid));
            }
        } else {
            Player player = world.getPlayerByUUID(uuid);
            if (player != null) {
                PlayerSound sound = soundCreator.apply(player);
                SoundHandler.playSound((SoundInstance)sound);
                knownSounds.put(uuid, sound);
            }
        }
    }

    @SafeVarargs
    private static void startSounds(Player player, Map<UUID, PlayerSound[]> knownSounds, Function<Player, PlayerSound> ... soundCreators) {
        UUID uuid = player.getUUID();
        if (knownSounds.containsKey(uuid)) {
            if (SoundHandler.playerSoundsEnabled()) {
                SoundHandler.restartSounds(knownSounds.get(uuid));
            }
        } else {
            PlayerSound[] sounds = new PlayerSound[soundCreators.length];
            for (int i = 0; i < soundCreators.length; ++i) {
                sounds[i] = soundCreators[i].apply(player);
                SoundHandler.playSound((SoundInstance)sounds[i]);
            }
            knownSounds.put(uuid, sounds);
        }
    }

    public static void restartSounds() {
        boolean hasPlayerSounds = SoundHandler.playerSoundsEnabled();
        if (hasPlayerSounds != hadPlayerSounds) {
            hadPlayerSounds = hasPlayerSounds;
            if (hasPlayerSounds) {
                jetpackSounds.values().forEach(xva$0 -> SoundHandler.restartSounds(xva$0));
                scubaMaskSounds.values().forEach(xva$0 -> SoundHandler.restartSounds(xva$0));
                flamethrowerSounds.values().forEach(SoundHandler::restartSounds);
                gravitationalModulationSounds.values().forEach(xva$0 -> SoundHandler.restartSounds(xva$0));
                radiationSoundMap.values().forEach(xva$0 -> SoundHandler.restartSounds(xva$0));
            }
        }
    }

    private static void restartSounds(PlayerSound ... sounds) {
        for (PlayerSound sound : sounds) {
            if (sound.isStopped() || soundEngine == null || SoundHandler.soundEngine.instanceToChannel.containsKey((Object)sound)) continue;
            SoundHandler.playSound((SoundInstance)sound);
        }
    }

    private static boolean playerSoundsEnabled() {
        return SoundHandler.getVolume(SoundSource.MASTER) > 0.0f && SoundHandler.getVolume(SoundSource.PLAYERS) > 0.0f;
    }

    private static float getVolume(SoundSource category) {
        return Minecraft.getInstance().options.getSoundSourceVolume(category);
    }

    public static void playSound(SoundEventRegistryObject<?> soundEventRO) {
        SoundHandler.playSound((SoundEvent)soundEventRO.get());
    }

    public static void playSound(SoundEvent sound) {
        SoundHandler.playSound((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f, (float)MekanismConfig.client.baseSoundVolume.get()));
    }

    public static void playSound(SoundInstance sound) {
        Minecraft.getInstance().getSoundManager().play(sound);
    }

    public static SoundInstance startTileSound(SoundEvent soundEvent, SoundSource category, float volume, RandomSource random, BlockPos pos) {
        return SoundHandler.startTileSound(soundEvent, category, volume, random, pos, true);
    }

    public static SoundInstance startTileSound(SoundEvent soundEvent, SoundSource category, float volume, RandomSource random, BlockPos pos, boolean looping) {
        Object s = (SoundInstance)soundMap.get(pos.asLong());
        if (s == null || !Minecraft.getInstance().getSoundManager().isActive(s)) {
            s = new TileTickableSound(soundEvent, category, random, pos, volume, looping);
            if (!SoundHandler.isClientPlayerInRange(s)) {
                return null;
            }
            SoundHandler.playSound(s);
            s = (SoundInstance)soundMap.get(pos.asLong());
        }
        return s;
    }

    public static void stopTileSound(BlockPos pos) {
        long posKey = pos.asLong();
        SoundInstance s = (SoundInstance)soundMap.get(posKey);
        if (s != null) {
            Minecraft.getInstance().getSoundManager().stop(s);
            soundMap.remove(posKey);
        }
    }

    private static boolean isClientPlayerInRange(SoundInstance sound) {
        if (sound.isRelative() || sound.getAttenuation() == SoundInstance.Attenuation.NONE) {
            return true;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        Sound s = sound.getSound();
        if (s == null) {
            sound.resolve(Minecraft.getInstance().getSoundManager());
            s = sound.getSound();
        }
        int attenuationDistance = s.getAttenuationDistance();
        float scaledDistance = Math.max(sound.getVolume(), 1.0f) * (float)attenuationDistance;
        return player.position().distanceToSqr(sound.getX(), sound.getY(), sound.getZ()) < (double)(scaledDistance * scaledDistance);
    }

    @SubscribeEvent
    public static void onSoundEngineSetup(SoundEngineLoadEvent event) {
        if (soundEngine == null) {
            soundEngine = event.getEngine();
        }
    }

    public static void onTilePlaySound(PlaySoundEvent event) {
        SoundInstance resultSound = event.getSound();
        if (resultSound == null || IN_MUFFLED_CHECK) {
            return;
        }
        ResourceLocation soundLoc = event.getOriginalSound().getLocation();
        if (!soundLoc.getNamespace().startsWith("mekanism")) {
            return;
        }
        SoundInstance soundInstance = event.getOriginalSound();
        if (soundInstance instanceof PlayerSound) {
            PlayerSound sound = (PlayerSound)soundInstance;
            event.setSound((SoundInstance)sound);
            return;
        }
        if (event.getName().startsWith("tile.")) {
            BlockPos pos = BlockPos.containing((double)(resultSound.getX() - 0.5), (double)(resultSound.getY() - 0.5), (double)(resultSound.getZ() - 0.5));
            soundMap.put(pos.asLong(), (Object)resultSound);
        }
    }

    private static class TileTickableSound
    extends AbstractTickableSoundInstance {
        private final float originalVolume;
        private final int checkInterval = 20 + ThreadLocalRandom.current().nextInt(20);

        TileTickableSound(SoundEvent soundEvent, SoundSource category, RandomSource random, BlockPos pos, float volume, boolean looping) {
            super(soundEvent, category, random);
            this.originalVolume = volume * MekanismConfig.client.baseSoundVolume.get();
            this.x = (float)pos.getX() + 0.5f;
            this.y = (float)pos.getY() + 0.5f;
            this.z = (float)pos.getZ() + 0.5f;
            this.volume = this.originalVolume * this.getTileVolumeFactor();
            this.looping = looping;
            this.delay = 0;
        }

        public void tick() {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                this.stop();
                return;
            }
            if (!MekanismUtils.isTickingNormally((Level)level)) {
                this.volume = 0.0f;
            } else if (level.getGameTime() % (long)this.checkInterval == 0L) {
                if (!SoundHandler.isClientPlayerInRange((SoundInstance)this)) {
                    this.stop();
                    return;
                }
                IN_MUFFLED_CHECK = true;
                this.volume = this.originalVolume;
                SoundInstance s = ClientHooks.playSound((SoundEngine)soundEngine, (SoundInstance)this);
                IN_MUFFLED_CHECK = false;
                if (s == this) {
                    this.volume = this.originalVolume * this.getTileVolumeFactor();
                } else if (s == null) {
                    this.stop();
                } else {
                    this.volume = s.getVolume() * this.getTileVolumeFactor();
                }
            }
        }

        private float getTileVolumeFactor() {
            IUpgradeTile upgradeTile;
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)Minecraft.getInstance().level, BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ()));
            float retVolume = 1.0f;
            if (tile instanceof IUpgradeTile && (upgradeTile = (IUpgradeTile)tile).supportsUpgrade(Upgrade.MUFFLING)) {
                int mufflerCount = Math.min(upgradeTile.getComponent().getUpgrades(Upgrade.MUFFLING), Upgrade.MUFFLING.getMax());
                retVolume = 1.0f - (float)mufflerCount / (float)Upgrade.MUFFLING.getMax();
            }
            if (tile instanceof ITileSound) {
                ITileSound tileSound = (ITileSound)tile;
                retVolume *= tileSound.getVolume();
            }
            return retVolume;
        }

        public float getVolume() {
            if (this.sound == null) {
                this.resolve(Minecraft.getInstance().getSoundManager());
            }
            return super.getVolume();
        }

        public boolean canStartSilent() {
            return true;
        }
    }
}

