/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.client.render.item.ChemicalFluidBarDecorator;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.GenericTankSpec;
import mekanism.common.capabilities.chemical.item.ChemicalTankSpec;
import mekanism.common.capabilities.fluid.item.FluidTankSpec;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.IItemDecorator;

public class MekaSuitBarDecorator
implements IItemDecorator {
    public static final MekaSuitBarDecorator INSTANCE = new MekaSuitBarDecorator();

    private MekaSuitBarDecorator() {
    }

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        List<FluidTankSpec> fluidTankSpecs;
        Item item;
        if (stack.isEmpty() || !((item = stack.getItem()) instanceof ItemMekaSuitArmor)) {
            return false;
        }
        ItemMekaSuitArmor armor = (ItemMekaSuitArmor)item;
        if (this.tryRender(guiGraphics, stack, xOffset, yOffset += 12, armor.getChemicalTankSpecs())) {
            --yOffset;
        }
        if (!(fluidTankSpecs = armor.getFluidTankSpecs()).isEmpty()) {
            List<IExtendedFluidTank> tanks = ContainerType.FLUID.getAttachmentContainersIfPresent(stack);
            int tank = MekaSuitBarDecorator.getDisplayTank(fluidTankSpecs, stack, tanks.size());
            if (tank != -1) {
                ChemicalFluidBarDecorator.renderBar(guiGraphics, xOffset, yOffset, tanks.get(tank));
            } else if (tanks.isEmpty()) {
                ChemicalFluidBarDecorator.renderBar(guiGraphics, xOffset, yOffset, 0L, 1L, -1);
            }
        }
        return true;
    }

    private boolean tryRender(GuiGraphics guiGraphics, ItemStack stack, int xOffset, int yOffset, List<ChemicalTankSpec> chemicalTankSpecs) {
        if (!chemicalTankSpecs.isEmpty()) {
            List<IChemicalTank> tanks = ContainerType.CHEMICAL.getAttachmentContainersIfPresent(stack);
            int tank = MekaSuitBarDecorator.getDisplayTank(chemicalTankSpecs, stack, tanks.size());
            if (tank != -1) {
                ChemicalFluidBarDecorator.renderBar(guiGraphics, xOffset, yOffset, tanks.get(tank));
            } else if (tanks.isEmpty()) {
                ChemicalFluidBarDecorator.renderBar(guiGraphics, xOffset, yOffset, 0L, 1L, -1);
            }
            return true;
        }
        return false;
    }

    private static <TYPE> int getDisplayTank(List<? extends GenericTankSpec<TYPE>> tankSpecs, ItemStack stack, int tanks) {
        if (tanks == 0) {
            return -1;
        }
        if (tanks > 1 && tanks == tankSpecs.size() && Minecraft.getInstance().level != null) {
            IntArrayList tankIndices = new IntArrayList(tanks);
            for (int i = 0; i < tanks; ++i) {
                if (!tankSpecs.get(i).supportsStack(stack)) continue;
                tankIndices.add(i);
            }
            int displayTank = ChemicalFluidBarDecorator.getDisplayTank(tankIndices.size());
            return displayTank == -1 ? -1 : tankIndices.getInt(displayTank);
        }
        for (int i = 0; i < tanks && i < tankSpecs.size(); ++i) {
            if (!tankSpecs.get(i).supportsStack(stack)) continue;
            return i;
        }
        return -1;
    }
}

