/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.text.IHasTranslationKey;
import mekanism.client.recipe_viewer.alias.RVAliasHelper;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.common.Mekanism;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class JEIAliasHelper
implements RVAliasHelper<ItemStack, FluidStack, ChemicalStack> {
    private static final Function<ItemStack, String> ITEM_TO_STRING = stack -> stack.getItem().toString();
    private static final Function<FluidStack, String> FLUID_TO_STRING = stack -> stack.getFluid().toString();
    private static final Function<ChemicalStack, String> CHEMICAL_TO_STRING = stack -> stack.getChemical().toString();
    private final IIngredientAliasRegistration registration;

    public JEIAliasHelper(IIngredientAliasRegistration registration) {
        this.registration = registration;
    }

    @Override
    public ItemStack ingredient(ItemStack item) {
        return item;
    }

    @Override
    public ItemStack itemIngredient(Holder<Item> item) {
        return new ItemStack(item);
    }

    @Override
    public List<ItemStack> itemTagContents(TagKey<Item> tag) {
        return this.tagContents((Registry)BuiltInRegistries.ITEM, (TagKey)tag, (Function)ItemStack::new);
    }

    @Override
    public FluidStack fluidIngredient(Holder<Fluid> fluid) {
        return new FluidStack(fluid, 1000);
    }

    @Override
    public FluidStack ingredient(FluidStack fluid) {
        return fluid;
    }

    @Override
    public List<FluidStack> fluidTagContents(TagKey<Fluid> tag) {
        return this.tagContents((Registry)BuiltInRegistries.FLUID, (TagKey)tag, (Function)holder -> new FluidStack(holder, 1000));
    }

    @Override
    public ChemicalStack chemicalIngredient(Holder<Chemical> chemical) {
        return new ChemicalStack(chemical, 1000L);
    }

    @Override
    public List<ChemicalStack> chemicalTagContents(TagKey<Chemical> tag) {
        return this.tagContents((Registry)MekanismAPI.CHEMICAL_REGISTRY, (TagKey)tag, (Function)holder -> new ChemicalStack((Holder<Chemical>)holder, 1000L));
    }

    private <TYPE, STACK> List<STACK> tagContents(Registry<TYPE> registry, TagKey<TYPE> tag, Function<Holder<TYPE>, STACK> stackFunction) {
        return registry.getTag(tag).stream().flatMap(HolderSet::stream).map(stackFunction).toList();
    }

    @Override
    public void addItemAliases(List<ItemStack> stacks, IHasTranslationKey ... aliases) {
        this.addAliases((IIngredientType)VanillaTypes.ITEM_STACK, (List)stacks, (Function)ITEM_TO_STRING, aliases);
    }

    @Override
    public void addFluidAliases(List<FluidStack> stacks, IHasTranslationKey ... aliases) {
        this.addAliases((IIngredientType)NeoForgeTypes.FLUID_STACK, (List)stacks, (Function)FLUID_TO_STRING, aliases);
    }

    @Override
    public void addChemicalAliases(List<ChemicalStack> stacks, IHasTranslationKey ... aliases) {
        this.addAliases(MekanismJEI.TYPE_CHEMICAL, stacks, CHEMICAL_TO_STRING, aliases);
    }

    private <INGREDIENT> void addAliases(IIngredientType<INGREDIENT> type, List<INGREDIENT> stacks, Function<INGREDIENT, String> ingredientToString, IHasTranslationKey ... aliases) {
        if (aliases.length == 0) {
            Mekanism.logger.warn("Expected to have at least one alias for ingredients of type: {}. Ingredients: {}", (Object)type.getUid(), (Object)stacks.stream().map(ingredientToString).collect(Collectors.joining(", ")));
        } else {
            List<String> aliasesAsString = Arrays.stream(aliases).map(IHasTranslationKey::getTranslationKey).toList();
            this.registration.addAliases(type, stacks, aliasesAsString);
        }
    }
}

