/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.GuiConfirmationDialog;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.item.FrequencyItemContainer;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IColorableFrequency;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.frequency.PacketSetFrequencyColor;
import mekanism.common.network.to_server.frequency.PacketSetItemFrequency;
import mekanism.common.network.to_server.frequency.PacketSetTileFrequency;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.text.InputValidator;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class GuiFrequencySelector<FREQ extends Frequency>
extends GuiElement {
    private final IGuiFrequencySelector<FREQ> frequencySelector;
    private final MekanismButton publicButton;
    private final MekanismButton trustedButton;
    private final MekanismButton privateButton;
    private final MekanismButton setButton;
    private final MekanismButton deleteButton;
    private final GuiTextScrollList scrollList;
    private final GuiTextField frequencyField;
    private List<FREQ> lastFrequencies = Collections.emptyList();
    private SecurityMode securityMode = SecurityMode.PUBLIC;
    private boolean init;

    public <SELECTOR extends IGuiWrapper & IGuiFrequencySelector<FREQ>> GuiFrequencySelector(SELECTOR frequencySelector, int yStart) {
        super(frequencySelector, 27, yStart, 132, 121);
        this.frequencySelector = frequencySelector;
        boolean hasColor = frequencySelector instanceof IGuiColorFrequencySelector;
        this.scrollList = this.addChild(new GuiTextScrollList(frequencySelector, this.relativeX, this.relativeY + 22, 122, 42));
        this.publicButton = this.addChild(new MekanismImageButton(frequencySelector, this.relativeX, this.relativeY, 38, 20, 38, 20, GuiFrequencySelector.getButtonLocation("public"), (element, mouseX, mouseY) -> {
            this.securityMode = SecurityMode.PUBLIC;
            this.scrollList.clearSelection();
            this.updateButtons();
            return true;
        })).setTooltip(MekanismLang.PUBLIC_MODE);
        this.trustedButton = this.addChild(new MekanismImageButton(frequencySelector, this.relativeX + 42, this.relativeY, 38, 20, 38, 20, GuiFrequencySelector.getButtonLocation("trusted"), (element, mouseX, mouseY) -> {
            this.securityMode = SecurityMode.TRUSTED;
            this.scrollList.clearSelection();
            this.updateButtons();
            return true;
        })).setTooltip(MekanismLang.TRUSTED_MODE);
        this.privateButton = this.addChild(new MekanismImageButton(frequencySelector, this.relativeX + 84, this.relativeY, 38, 20, 38, 20, GuiFrequencySelector.getButtonLocation("private"), (element, mouseX, mouseY) -> {
            this.securityMode = SecurityMode.PRIVATE;
            this.scrollList.clearSelection();
            this.updateButtons();
            return true;
        })).setTooltip(MekanismLang.PRIVATE_MODE);
        int buttonWidth = hasColor ? 50 : 60;
        this.setButton = this.addChild(new TranslationButton(frequencySelector, this.relativeX, this.relativeY + 113, buttonWidth, 18, MekanismLang.BUTTON_SET, (element, mouseX, mouseY) -> {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency frequency = (Frequency)this.getFrequencies().get(selection);
                this.setFrequency(frequency.getName(), frequency.getOwner());
            }
            this.updateButtons();
            return true;
        }));
        this.deleteButton = this.addChild(new TranslationButton(frequencySelector, this.relativeX + 2 + buttonWidth, this.relativeY + 113, buttonWidth, 18, MekanismLang.BUTTON_DELETE, (element, mouseX, mouseY) -> {
            GuiConfirmationDialog.show(this.gui(), (Component)MekanismLang.FREQUENCY_DELETE_CONFIRM.translate(), () -> {
                int selection = this.scrollList.getSelection();
                if (selection != -1) {
                    Frequency frequency = (Frequency)this.getFrequencies().get(selection);
                    this.frequencySelector.sendRemoveFrequency(frequency.getIdentity());
                    this.scrollList.clearSelection();
                }
                this.updateButtons();
            }, GuiConfirmationDialog.DialogType.DANGER);
            return true;
        }));
        if (hasColor) {
            this.addChild(new GuiSlot(SlotType.NORMAL, frequencySelector, this.relativeX + 104, this.relativeY + 113));
            IGuiColorFrequencySelector colorFrequencySelector = (IGuiColorFrequencySelector)frequencySelector;
            this.addChild(new ColorButton(frequencySelector, this.relativeX + 105, this.relativeY + 114, 16, 16, () -> {
                IColorableFrequency frequency = (IColorableFrequency)colorFrequencySelector.getFrequency();
                return frequency == null ? null : frequency.getColor();
            }, (element, mouseX, mouseY) -> {
                colorFrequencySelector.sendColorUpdate(true);
                return true;
            }, (element, mouseX, mouseY) -> {
                colorFrequencySelector.sendColorUpdate(false);
                return true;
            }));
        }
        this.frequencyField = this.addChild(new GuiTextField(frequencySelector, this, this.relativeX + 23, this.relativeY + 99, 98, 11));
        this.frequencyField.setMaxLength(16);
        this.frequencyField.setBackground(BackgroundType.INNER_SCREEN);
        this.frequencyField.setEnterHandler(this::setFrequency);
        this.frequencyField.setInputValidator(InputValidator.LETTER_OR_DIGIT.or(InputValidator.FREQUENCY_CHARS));
        this.frequencyField.addCheckmarkButton(this::setFrequency);
        this.publicButton.active = false;
        this.setButton.active = false;
        this.deleteButton.active = false;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.init) {
            this.init = true;
            FREQ frequency = this.frequencySelector.getFrequency();
            if (frequency != null) {
                this.securityMode = ((Frequency)frequency).getSecurity();
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        List<FREQ> frequencies = this.getFrequencies();
        if (this.lastFrequencies != frequencies) {
            this.lastFrequencies = frequencies;
            ArrayList<String> text = new ArrayList<String>(frequencies.size());
            for (Frequency freq : frequencies) {
                if (this.securityMode == SecurityMode.PRIVATE) {
                    text.add(freq.getName());
                    continue;
                }
                text.add(freq.getName() + " (" + freq.getOwnerName() + ")");
            }
            this.scrollList.setText(text);
        }
        this.publicButton.active = this.securityMode != SecurityMode.PUBLIC;
        this.trustedButton.active = this.securityMode != SecurityMode.TRUSTED;
        boolean bl = this.privateButton.active = this.securityMode != SecurityMode.PRIVATE;
        if (this.scrollList.hasSelection()) {
            Frequency selectedFrequency = (Frequency)frequencies.get(this.scrollList.getSelection());
            FREQ currentFrequency = this.frequencySelector.getFrequency();
            this.setButton.active = currentFrequency == null || !((Frequency)currentFrequency).equals(selectedFrequency);
            this.deleteButton.active = Minecraft.getInstance().player != null && selectedFrequency.ownerMatches(Minecraft.getInstance().player.getUUID());
        } else {
            this.setButton.active = false;
            this.deleteButton.active = false;
        }
        this.frequencySelector.buttonsUpdated();
    }

    private List<FREQ> getFrequencies() {
        return switch (this.securityMode) {
            default -> throw new MatchException(null, null);
            case SecurityMode.PUBLIC -> this.frequencySelector.getPublicFrequencies();
            case SecurityMode.PRIVATE -> this.frequencySelector.getPrivateFrequencies();
            case SecurityMode.TRUSTED -> this.frequencySelector.getTrustedFrequencies();
        };
    }

    private void setFrequency() {
        this.setFrequency(this.frequencyField.getText(), Minecraft.getInstance().player == null ? null : Minecraft.getInstance().player.getUUID());
        this.frequencyField.setText("");
        this.updateButtons();
    }

    private void setFrequency(String freq, @Nullable UUID ownerUUID) {
        if (!freq.isEmpty()) {
            this.frequencySelector.sendSetFrequency(new Frequency.FrequencyIdentity(freq, this.securityMode, ownerUUID));
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Object frequencySecurity;
        MutableComponent ownerComponent;
        MutableComponent frequencyName;
        super.renderForeground(guiGraphics, mouseX, mouseY);
        FREQ frequency = this.frequencySelector.getFrequency();
        if (frequency == null) {
            MutableComponent noneComponent;
            frequencyName = noneComponent = MekanismLang.NONE.translateColored(EnumColor.DARK_RED);
            ownerComponent = MekanismLang.OWNER.translate(noneComponent);
            frequencySecurity = noneComponent;
        } else {
            frequencyName = TextComponentUtil.color(TextComponentUtil.getString(((Frequency)frequency).getName()), this.subheadingTextColor());
            ownerComponent = OwnerDisplay.of((Player)Minecraft.getInstance().player, ((Frequency)frequency).getOwner(), ((Frequency)frequency).getOwnerName(), false).getTextComponent();
            frequencySecurity = ((Frequency)frequency).getSecurity();
        }
        int textEnd = this.getGuiWidth() - this.relativeX - 10;
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.FREQUENCY.translate(frequencyName), 0, 67, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textEnd, 0, false);
        this.drawScrollingString(guiGraphics, (Component)ownerComponent, 0, 77, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textEnd, 0, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.SECURITY.translate(frequencySecurity), 0, 87, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textEnd, 0, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.SET.translate(), -this.relativeX, 100, IFancyFontRenderer.TextAlignment.RIGHT, this.titleTextColor(), this.frequencyField.getRelativeX(), 5, false);
    }

    public static interface IGuiFrequencySelector<FREQ extends Frequency> {
        public FrequencyType<FREQ> getFrequencyType();

        public void sendSetFrequency(Frequency.FrequencyIdentity var1);

        public void sendRemoveFrequency(Frequency.FrequencyIdentity var1);

        @Nullable
        public FREQ getFrequency();

        public List<FREQ> getPublicFrequencies();

        public List<FREQ> getTrustedFrequencies();

        public List<FREQ> getPrivateFrequencies();

        default public void buttonsUpdated() {
        }
    }

    public static interface IGuiColorFrequencySelector<FREQ extends Frequency>
    extends IGuiFrequencySelector<FREQ> {
        default public void sendColorUpdate(boolean next) {
            Object freq = this.getFrequency();
            if (freq != null) {
                PacketUtils.sendToServer(new PacketSetFrequencyColor(freq, next));
            }
        }
    }

    public static interface IItemGuiFrequencySelector<FREQ extends Frequency, CONTAINER extends FrequencyItemContainer<FREQ>>
    extends IGuiFrequencySelector<FREQ> {
        public CONTAINER getFrequencyContainer();

        @Override
        default public void sendSetFrequency(Frequency.FrequencyIdentity identity) {
            this.sendSetFrequency(identity, true);
        }

        @Override
        default public void sendRemoveFrequency(Frequency.FrequencyIdentity identity) {
            this.sendSetFrequency(identity, false);
        }

        private void sendSetFrequency(Frequency.FrequencyIdentity identity, boolean set) {
            PacketUtils.sendToServer(new PacketSetItemFrequency(set, this.getFrequencyType(), identity, ((FrequencyItemContainer)this.getFrequencyContainer()).getHand()));
        }

        @Override
        @Nullable
        default public FREQ getFrequency() {
            return ((FrequencyItemContainer)this.getFrequencyContainer()).getClientFrequency();
        }

        @Override
        default public List<FREQ> getPublicFrequencies() {
            return ((FrequencyItemContainer)this.getFrequencyContainer()).getPublicCache();
        }

        @Override
        default public List<FREQ> getTrustedFrequencies() {
            return ((FrequencyItemContainer)this.getFrequencyContainer()).getTrustedCache();
        }

        @Override
        default public List<FREQ> getPrivateFrequencies() {
            return ((FrequencyItemContainer)this.getFrequencyContainer()).getPrivateCache();
        }
    }

    public static interface ITileGuiFrequencySelector<FREQ extends Frequency, TILE extends TileEntityMekanism>
    extends IGuiFrequencySelector<FREQ> {
        public TILE getTileEntity();

        @Override
        default public void sendSetFrequency(Frequency.FrequencyIdentity identity) {
            this.sendSetFrequency(identity, true);
        }

        @Override
        default public void sendRemoveFrequency(Frequency.FrequencyIdentity identity) {
            this.sendSetFrequency(identity, false);
        }

        private void sendSetFrequency(Frequency.FrequencyIdentity identity, boolean set) {
            PacketUtils.sendToServer(new PacketSetTileFrequency(set, this.getFrequencyType(), identity, this.getTileEntity().getBlockPos()));
        }

        @Override
        @Nullable
        default public FREQ getFrequency() {
            return (FREQ)this.getTileEntity().getFrequency(this.getFrequencyType());
        }

        @Override
        default public List<FREQ> getPublicFrequencies() {
            return this.getTileEntity().getPublicCache(this.getFrequencyType());
        }

        @Override
        default public List<FREQ> getTrustedFrequencies() {
            return this.getTileEntity().getTrustedCache(this.getFrequencyType());
        }

        @Override
        default public List<FREQ> getPrivateFrequencies() {
            return this.getTileEntity().getPrivateCache(this.getFrequencyType());
        }
    }
}

