/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

@NothingNullByDefault
public class BasicItemStackToEnergyRecipe
extends ItemStackToEnergyRecipe {
    protected final ItemStackIngredient input;
    protected final long output;

    public BasicItemStackToEnergyRecipe(ItemStackIngredient input, long output) {
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        if (output <= 0L) {
            throw new IllegalArgumentException("Output must be greater than zero.");
        }
        this.output = output;
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.input.test(itemStack);
    }

    @Override
    public ItemStackIngredient getInput() {
        return this.input;
    }

    @Override
    public long getOutput(ItemStack input) {
        return this.output;
    }

    public long getOutputRaw() {
        return this.output;
    }

    @Override
    public long[] getOutputDefinition() {
        return new long[]{this.output};
    }

    public RecipeSerializer<BasicItemStackToEnergyRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.ENERGY_CONVERSION.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicItemStackToEnergyRecipe other = (BasicItemStackToEnergyRecipe)o;
        return this.output == other.output && this.input.equals(other.input);
    }

    public int hashCode() {
        int result = this.input.hashCode();
        result = 31 * result + Long.hashCode(this.output);
        return result;
    }
}

