/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datamaps.chemical.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.datamaps.chemical.attribute.IChemicalAttribute;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ITooltipHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.ApiStatus;

public record ChemicalRadioactivity(double radioactivity) implements IChemicalAttribute
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"chemical_attribute_radioactivity");
    private static final Codec<Double> RADIATION_CODEC = Codec.doubleRange((double)IRadiationManager.INSTANCE.baselineRadiation(), (double)Double.MAX_VALUE).validate(val -> {
        if (val.doubleValue() == IRadiationManager.INSTANCE.baselineRadiation()) {
            return DataResult.error(() -> "Radiation must be greater than the baseline value");
        }
        return DataResult.success((Object)val);
    });
    public static final Codec<ChemicalRadioactivity> RADIOACTIVITY_CODEC = RADIATION_CODEC.xmap(ChemicalRadioactivity::new, ChemicalRadioactivity::radioactivity);
    public static final Codec<ChemicalRadioactivity> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(in -> in.group((App)RADIATION_CODEC.fieldOf("radioactivity").forGetter(ChemicalRadioactivity::radioactivity)).apply((Applicative)in, ChemicalRadioactivity::new)), RADIOACTIVITY_CODEC);

    public ChemicalRadioactivity {
        if (radioactivity <= IRadiationManager.INSTANCE.baselineRadiation()) {
            throw new IllegalArgumentException("Radiation attribute should only be used when there actually is radiation! Radioactivity: " + radioactivity);
        }
    }

    @Override
    public void collectTooltips(Item.TooltipContext context, List<Component> tooltips, TooltipFlag tooltipFlag) {
        if (this.needsValidation()) {
            ITooltipHelper tooltipHelper = ITooltipHelper.INSTANCE;
            tooltips.add((Component)APILang.CHEMICAL_ATTRIBUTE_RADIATION.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getRadioactivityDisplayShort(this.radioactivity)));
        }
    }

    @Override
    public boolean needsValidation() {
        return IRadiationManager.INSTANCE.isRadiationEnabled();
    }

    @Override
    @ApiStatus.Internal
    public ChemicalAttributes.Radiation toLegacyAttribute() {
        return new ChemicalAttributes.Radiation(this);
    }
}

