/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class CatSpawner
implements CustomSpawner {
    private static final int TICK_DELAY = 1200;
    private int nextTick;

    public int tick(ServerLevel p_35330_, boolean p_35331_, boolean p_35332_) {
        if (p_35332_ && p_35330_.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            --this.nextTick;
            if (this.nextTick > 0) {
                return 0;
            }
            this.nextTick = 1200;
            ServerPlayer player = p_35330_.getRandomPlayer();
            if (player == null) {
                return 0;
            }
            RandomSource randomsource = p_35330_.random;
            int i = (8 + randomsource.nextInt(24)) * (randomsource.nextBoolean() ? -1 : 1);
            int j = (8 + randomsource.nextInt(24)) * (randomsource.nextBoolean() ? -1 : 1);
            BlockPos blockpos = player.blockPosition().offset(i, 0, j);
            int k = 10;
            if (!p_35330_.hasChunksAt(blockpos.getX() - 10, blockpos.getZ() - 10, blockpos.getX() + 10, blockpos.getZ() + 10)) {
                return 0;
            }
            if (SpawnPlacements.isSpawnPositionOk(EntityType.CAT, (LevelReader)((Object)p_35330_), blockpos)) {
                if (p_35330_.isCloseToVillage(blockpos, 2)) {
                    return this.spawnInVillage(p_35330_, blockpos);
                }
                if (p_35330_.structureManager().getStructureWithPieceAt(blockpos, StructureTags.CATS_SPAWN_IN).isValid()) {
                    return this.spawnInHut(p_35330_, blockpos);
                }
            }
            return 0;
        }
        return 0;
    }

    private int spawnInVillage(ServerLevel p_35327_, BlockPos p_35328_) {
        List list;
        int i = 48;
        if (p_35327_.getPoiManager().getCountInRange(p_219610_ -> p_219610_.is(PoiTypes.HOME), p_35328_, 48, PoiManager.Occupancy.IS_OCCUPIED) > 4L && (list = p_35327_.getEntitiesOfClass(Cat.class, new AABB(p_35328_).inflate(48.0, 8.0, 48.0))).size() < 5) {
            return this.spawnCat(p_35328_, p_35327_);
        }
        return 0;
    }

    private int spawnInHut(ServerLevel p_35337_, BlockPos p_35338_) {
        int i = 16;
        List list = p_35337_.getEntitiesOfClass(Cat.class, new AABB(p_35338_).inflate(16.0, 8.0, 16.0));
        return list.size() < 1 ? this.spawnCat(p_35338_, p_35337_) : 0;
    }

    private int spawnCat(BlockPos p_35334_, ServerLevel p_35335_) {
        Cat cat = EntityType.CAT.create(p_35335_);
        if (cat == null) {
            return 0;
        }
        cat.moveTo(p_35334_, 0.0f, 0.0f);
        cat.finalizeSpawn((ServerLevelAccessor)p_35335_, p_35335_.getCurrentDifficultyAt(p_35334_), MobSpawnType.NATURAL, null);
        p_35335_.addFreshEntityWithPassengers((Entity)((Object)cat));
        return 1;
    }
}

