/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.FlowerPotHandler;
import net.mehvahdjukaar.amendments.common.tile.HangingFlowerPotBlockTile;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HangingFlowerPotBlock
extends Block
implements EntityBlock {
    public static final MapCodec<HangingFlowerPotBlock> CODEC = HangingFlowerPotBlock.simpleCodec(HangingFlowerPotBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL;

    public HangingFlowerPotBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> (Integer)state.getValue((Property)LIGHT_LEVEL)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends HangingFlowerPotBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIGHT_LEVEL});
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        Item i = stack.getItem();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof HangingFlowerPotBlockTile) {
            HangingFlowerPotBlockTile tile = (HangingFlowerPotBlockTile)blockEntity;
            if (i instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)i;
                BlockState mimic = blockItem.getBlock().defaultBlockState();
                tile.setHeldBlock(mimic);
            }
        }
    }

    public MutableComponent getName() {
        return Component.translatable((String)"block.minecraft.flower_pot");
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return context.getClickedFace() == Direction.DOWN ? super.getStateForPlacement(context) : null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        HangingFlowerPotBlockTile tile;
        Block pot;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HangingFlowerPotBlockTile && (pot = (tile = (HangingFlowerPotBlockTile)blockEntity).getHeldBlock().getBlock()) instanceof FlowerPotBlock) {
            Block block;
            FlowerPotBlock flowerPot = (FlowerPotBlock)pot;
            ItemStack itemstack = player.getItemInHand(hand);
            Item item = itemstack.getItem();
            if (item instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                block = FlowerPotHandler.getFullPot(flowerPot, bi.getBlock());
            } else {
                block = Blocks.AIR;
            }
            Block newPot = block;
            boolean isEmptyFlower = newPot == Blocks.AIR;
            boolean isPotEmpty = FlowerPotHandler.isEmptyPot(pot);
            if (isEmptyFlower != isPotEmpty) {
                if (isPotEmpty) {
                    if (!level.isClientSide) {
                        tile.setHeldBlock(newPot.defaultBlockState());
                        level.sendBlockUpdated(pos, state, state, 2);
                        tile.setChanged();
                    }
                    HangingFlowerPotBlock.playPlantSound(level, pos, player);
                    player.awardStat(Stats.POT_FLOWER);
                    itemstack.consume(1, (LivingEntity)player);
                } else {
                    ItemStack flowerItem = pot.getCloneItemStack((LevelReader)level, pos, state);
                    if (!flowerItem.equals(new ItemStack((ItemLike)this))) {
                        if (itemstack.isEmpty()) {
                            player.setItemInHand(hand, flowerItem);
                        } else if (!player.addItem(flowerItem)) {
                            player.drop(flowerItem, false);
                        }
                    }
                    if (!level.isClientSide) {
                        tile.setHeldBlock(FlowerPotHandler.getEmptyPot(flowerPot).defaultBlockState());
                        level.sendBlockUpdated(pos, state, state, 2);
                        tile.setChanged();
                    }
                }
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static void playPlantSound(Level level, BlockPos pos, Player player) {
        level.playSound(player, pos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.95f);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new HangingFlowerPotBlockTile(pPos, pState);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        HangingFlowerPotBlockTile te;
        Block block;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HangingFlowerPotBlockTile && (block = (te = (HangingFlowerPotBlockTile)blockEntity).getHeldBlock().getBlock()) instanceof FlowerPotBlock) {
            FlowerPotBlock b = (FlowerPotBlock)block;
            Block flower = b.getPotted();
            if (flower == Blocks.AIR) {
                return new ItemStack((ItemLike)Blocks.FLOWER_POT, 1);
            }
            return new ItemStack((ItemLike)flower);
        }
        return new ItemStack((ItemLike)Blocks.FLOWER_POT, 1);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        HangingFlowerPotBlockTile tile;
        Block block;
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof HangingFlowerPotBlockTile && (block = (tile = (HangingFlowerPotBlockTile)((Object)object)).getHeldBlock().getBlock()) instanceof FlowerPotBlock) {
            FlowerPotBlock flowerPotBlock = (FlowerPotBlock)block;
            return Arrays.asList(new ItemStack((ItemLike)flowerPotBlock.getPotted()), new ItemStack((ItemLike)Items.FLOWER_POT));
        }
        return super.getDrops(state, builder);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.block();
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.UP && !this.canSurvive(stateIn, (LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return Amendments.isSupportingCeiling(pos.relative(Direction.UP), worldIn);
    }
}

