/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.render.IItemActionPayloadBuilder;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.network.DepositItemsPayload;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class ItemInteractionHandler {
    public static final int INTERACTION_RANGE = 10;
    private static List<IItemActionPayloadBuilder<?>> payloadBuilders = new ArrayList();

    public static void registerPayloadBuilder(IItemActionPayloadBuilder<?> payloadBuilder) {
        payloadBuilders.add(payloadBuilder);
    }

    public static void depositMultipleItems(Player player, boolean mainInventory, boolean hotbar, boolean onlyMatching) {
        if (!mainInventory && !hotbar) {
            throw new IllegalArgumentException("At least one of mainInventory or hotbar must be true");
        }
        int minSlot = hotbar ? 0 : 9;
        int maxSlot = mainInventory ? 36 : 9;
        ItemInteractionHandler.depositItem(player, minSlot, maxSlot, onlyMatching);
    }

    public static void depositItem(Player player, int itemSlot, boolean onlyMatching) {
        ItemInteractionHandler.depositItem(player, itemSlot, itemSlot + 1, onlyMatching);
    }

    private static void depositItem(Player player, int minSlot, int maxSlot, boolean onlyMatching) {
        HashSet storages = new HashSet();
        HashSet controllers = new HashSet();
        WorldHelper.getBlockEntitiesInRange(player.level(), player.blockPosition(), 10, IControllableStorage.class).forEach(s -> s.getControllerPos().ifPresentOrElse(controllers::add, () -> storages.add(s.getStorageBlockPos())));
        WorldHelper.getBlockEntitiesInRange(player.level(), player.blockPosition(), 10, ControllerBlockEntityBase.class).forEach(c -> controllers.add(c.getBlockPos()));
        LinkedHashMap<ResourceLocation, Object> extras = new LinkedHashMap<ResourceLocation, Object>();
        payloadBuilders.forEach(h -> h.buildClientRequestData(player).ifPresent(data -> extras.put(h.getPayloadHandlerId(), data)));
        if (!(storages.isEmpty() && controllers.isEmpty() && extras.isEmpty())) {
            PacketDistributor.sendToServer((CustomPacketPayload)new DepositItemsPayload(minSlot, maxSlot, new ArrayList<BlockPos>(storages), new ArrayList<BlockPos>(controllers), extras, onlyMatching), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            player.displayClientMessage((Component)TranslationHelper.INSTANCE.translStatusMessage("no_storage_in_range", new Object[0]).setStyle(Style.EMPTY.withColor(0xFF5555)), true);
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 1.0f, 0.45f + RandHelper.getRandomMinusOneToOne(player.level().random) * 0.1f);
        }
    }
}

