/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class ConfigurableFreezeTopLayer
extends Feature<Config> {
    public ConfigurableFreezeTopLayer(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        WorldGenLevel worldGenLevel = context.level();
        BlockPos blockPos = context.origin();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutableBlockPos2 = new BlockPos.MutableBlockPos();
        Config config = (Config)context.config();
        BlockStateProvider ice = config.ice();
        BlockStateProvider snow = config.snow();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int k = blockPos.getX() + i;
                int l = blockPos.getZ() + j;
                int m = worldGenLevel.getHeight(Heightmap.Types.MOTION_BLOCKING, k, l);
                mutableBlockPos.set(k, m, l);
                mutableBlockPos2.set((Vec3i)mutableBlockPos).move(Direction.DOWN, 1);
                Biome biome = (Biome)worldGenLevel.getBiome((BlockPos)mutableBlockPos).value();
                if (biome.shouldFreeze((LevelReader)worldGenLevel, (BlockPos)mutableBlockPos2, false)) {
                    worldGenLevel.setBlock((BlockPos)mutableBlockPos2, ice.getState(context.random(), (BlockPos)mutableBlockPos2), 2);
                }
                if (!biome.shouldSnow((LevelReader)worldGenLevel, (BlockPos)mutableBlockPos)) continue;
                worldGenLevel.setBlock((BlockPos)mutableBlockPos, Blocks.SNOW.defaultBlockState(), 2);
                BlockState blockState = worldGenLevel.getBlockState((BlockPos)mutableBlockPos2);
                if (!blockState.hasProperty((Property)SnowyDirtBlock.SNOWY)) continue;
                worldGenLevel.setBlock((BlockPos)mutableBlockPos2, (BlockState)blockState.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return true;
    }

    public record Config(BlockStateProvider ice, BlockStateProvider snow) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("ice").forGetter(Config::ice), (App)BlockStateProvider.CODEC.fieldOf("snow").forGetter(Config::snow)).apply((Applicative)instance, Config::new));
    }
}

