/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.tree.fruit;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import org.jetbrains.annotations.NotNull;

public class BWGFruitBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<BWGFruitBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BWGFruitBlock.propertiesCodec(), (App)ResourceLocation.CODEC.fieldOf("fruit").forGetter(item -> BuiltInRegistries.ITEM.getKey((Object)item.fruit.get().get())), (App)ResourceLocation.CODEC.fieldOf("leaves").forGetter(block -> BuiltInRegistries.BLOCK.getKey((Object)((Block)block.leaves.get())))).apply((Applicative)instance, BWGFruitBlock::new));
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final int MAX_AGE = 3;
    private final Supplier<Supplier<Item>> fruit;
    private final Supplier<LeavesBlock> leaves;

    public BWGFruitBlock(BlockBehaviour.Properties properties, Supplier<Supplier<Item>> fruit, String leaves) {
        super(properties);
        this.fruit = fruit;
        this.leaves = Suppliers.memoize(() -> (LeavesBlock)BuiltInRegistries.BLOCK.get(BiomesWeveGone.id(leaves)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public BWGFruitBlock(BlockBehaviour.Properties properties, Supplier<Supplier<Item>> fruit, Supplier<LeavesBlock> leaves) {
        super(properties);
        this.fruit = fruit;
        this.leaves = leaves;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    private BWGFruitBlock(BlockBehaviour.Properties properties, ResourceLocation fruitLocation, ResourceLocation leavesLocation) {
        this(properties, (Supplier<Supplier<Item>>)Suppliers.memoize(() -> () -> (Item)BuiltInRegistries.ITEM.get(fruitLocation)), (Supplier<LeavesBlock>)Suppliers.memoize(() -> (LeavesBlock)BuiltInRegistries.BLOCK.get(leavesLocation)));
    }

    public BWGFruitBlock(Supplier<Supplier<Item>> fruit, String leaves) {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().sound(SoundType.SWEET_BERRY_BUSH).pushReaction(PushReaction.DESTROY), fruit, leaves);
    }

    @NotNull
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Integer)state.getValue((Property)AGE)) {
            case 0 -> Block.box((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
            case 1 -> Block.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
            case 2 -> Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
            case 3 -> Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(state.getValue((Property)AGE)));
        };
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return this.fruit.get().get().getDefaultInstance();
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (player.isCreative() && (Integer)state.getValue((Property)AGE) != 3 && stack.is(this.getFruit())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)), 2);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if ((Integer)state.getValue((Property)AGE) == 3) {
            BWGFruitBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)this.fruit.get().get().getDefaultInstance());
            level.playSound(player, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.above()).is((Block)this.leaves.get());
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    public void randomTick(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 3 && level.getRawBrightness(pos.above(), 0) >= 9 && random.nextInt(5) == 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
        }
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min(3, (Integer)state.getValue((Property)AGE) + 1))), 2);
    }

    protected void onProjectileHit(@NotNull Level level, @NotNull BlockState state, @NotNull BlockHitResult hit, @NotNull Projectile projectile) {
        if (level.isClientSide()) {
            return;
        }
        level.destroyBlock(hit.getBlockPos(), true, (Entity)projectile);
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        if (context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).getEntity() instanceof LivingEntity) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    @NotNull
    public Item getFruit() {
        return this.fruit.get().get();
    }

    @NotNull
    public LeavesBlock getLeaves() {
        return this.leaves.get();
    }
}

