/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.plants.bush;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.potionstudios.biomeswevegone.world.entity.oddion.Oddion;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.BWGBerryBush;
import org.jetbrains.annotations.NotNull;

public class OddionCrop
extends BWGBerryBush {
    public static final IntegerProperty TIMER = IntegerProperty.create((String)"timer", (int)0, (int)10);
    public static final BooleanProperty HATCHING = BooleanProperty.create((String)"hatching");

    public OddionCrop() {
        super(() -> BWGItems.ODDION_BULB, false);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HATCHING, (Comparable)Boolean.valueOf(false))).setValue((Property)TIMER, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (stack.is(ItemTags.HOES) && (Integer)state.getValue((Property)AGE) == 3) {
            this.maxAgeHarvest(state, level, pos, player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (stack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if ((Integer)state.getValue((Property)AGE) == 3) {
            this.maxAgeHarvest(state, level, pos, player);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    private void maxAgeHarvest(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        OddionCrop.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BWGItems.ODDION_BULB.get(), 2));
        level.playSound(player, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        BlockState blockState = (BlockState)((BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1))).setValue((Property)TIMER, (Comparable)Integer.valueOf(0))).setValue((Property)HATCHING, (Comparable)Boolean.valueOf(false));
        level.setBlock(pos, blockState, 2);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
    }

    private boolean shouldHatch(@NotNull ServerLevel level, @NotNull BlockState state) {
        return level.getRandom().nextInt(10 - (Integer)state.getValue((Property)TIMER)) == 0;
    }

    public boolean isRandomlyTicking(@NotNull BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3 || (Boolean)state.getValue((Property)HATCHING) != false;
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)HATCHING)).booleanValue()) {
            if (this.shouldHatch(level, state)) {
                this.spawnOddion(level, pos);
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TIMER, (Comparable)Integer.valueOf((Integer)state.getValue((Property)TIMER) + 1)));
                level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return;
        }
        super.randomTick(state, level, pos, random);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)HATCHING)).booleanValue() && random.nextInt(6) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{TIMER, HATCHING}));
    }

    protected boolean mayPlaceOn(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.getBlock() instanceof FarmBlock;
    }

    private void spawnOddion(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Oddion oddion = new Oddion((Level)level);
        oddion.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        level.addFreshEntity((Entity)oddion);
        level.destroyBlock(pos, true);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return (Boolean)state.getValue((Property)HATCHING) == false;
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        if ((Integer)state.getValue((Property)AGE) == 3) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HATCHING, (Comparable)Boolean.valueOf(true)));
        } else {
            super.performBonemeal(level, random, pos, state);
        }
    }
}

