/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.potionstudios.biomeswevegone.util.BoneMealHandler;
import org.jetbrains.annotations.NotNull;

public class BWGSpreadableBlock
extends GrassBlock
implements BonemealableBlock {
    private final Supplier<? extends Block> spreadable;

    public BWGSpreadableBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> spreadable) {
        super(properties);
        this.spreadable = spreadable;
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!SpreadingSnowyDirtBlock.canBeGrass((BlockState)state, (LevelReader)level, (BlockPos)pos)) {
            level.setBlockAndUpdate(pos, this.spreadable.get().defaultBlockState());
        } else if (level.getMaxLocalRawBrightness(pos.above()) >= 9) {
            BlockState blockstate = this.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (!level.getBlockState(blockpos).is(this.spreadable.get()) || !SpreadingSnowyDirtBlock.canPropagate((BlockState)blockstate, (LevelReader)level, (BlockPos)blockpos)) continue;
                level.setBlockAndUpdate(blockpos, (BlockState)blockstate.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(level.getBlockState(blockpos.above()).is(Blocks.SNOW))));
            }
        }
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        BoneMealHandler.grassBoneMealHandler(level, pos.above(), (Block)this, (ResourceKey<PlacedFeature>)VegetationPlacements.GRASS_BONEMEAL, true, (Block)this);
    }
}

