/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2.5.0")
class BWGVillagerUpgradeCommand {
    BWGVillagerUpgradeCommand() {
    }

    static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder upgradeVillagers = LiteralArgumentBuilder.literal((String)"upgrade_villagers");
        upgradeVillagers.requires(commandSourceStack -> PlatformHandler.PLATFORM_HANDLER.hasPermission((CommandSourceStack)commandSourceStack, "biomeswevegone.commands.upgrade_villagers"));
        upgradeVillagers.executes(context -> {
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            ServerLevel level = server.getLevel(Level.OVERWORLD);
            level.getAllEntities().forEach(entity -> {
                if (entity instanceof Villager) {
                    Villager villager = (Villager)entity;
                    Holder biome = level.getBiome(villager.blockPosition());
                    if (biome.is(BWGBiomes.SKYRIS_VALE)) {
                        villager.setVillagerData(villager.getVillagerData().setType(BWGVillagerTypes.SKYRIS.get()));
                    } else if (biome.is(BWGBiomes.WEEPING_WITCH_FOREST)) {
                        villager.setVillagerData(villager.getVillagerData().setType(BWGVillagerTypes.SALEM.get()));
                    } else if (biome.is(BWGBiomes.RED_ROCK_VALLEY) || biome.is(BWGBiomes.RED_ROCK_PEAKS)) {
                        villager.setVillagerData(villager.getVillagerData().setType(BWGVillagerTypes.RED_ROCK.get()));
                    }
                    villager.refreshBrain(level);
                }
            });
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"biomeswevegone.commands.upgrade_villagers.success").withStyle(ChatFormatting.GREEN), true);
            return 1;
        });
        return upgradeVillagers;
    }
}

