/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.tools.basetools;

import com.direwolf20.justdirethings.common.entities.JustDireArrow;
import com.direwolf20.justdirethings.common.items.PotionCanister;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.Helpers;
import com.direwolf20.justdirethings.common.items.interfaces.LeftClickableTool;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.util.TooltipHelpers;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseBow
extends BowItem
implements ToggleableTool,
LeftClickableTool {
    protected final EnumSet<Ability> abilities = EnumSet.noneOf(Ability.class);
    protected final Map<Ability, AbilityParams> abilityParams = new EnumMap<Ability, AbilityParams>(Ability.class);

    public BaseBow(Item.Properties properties) {
        super(properties);
    }

    public float getMaxDraw() {
        return 20.0f;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.isShiftKeyDown()) {
            this.openSettings(player);
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        Item item = stack.getItem();
        if (item instanceof PoweredTool) {
            PoweredTool poweredTool = (PoweredTool)item;
            if (PoweredItem.getAvailableEnergy(stack) < poweredTool.getBlockBreakFECost()) {
                return InteractionResultHolder.pass((Object)stack);
            }
        }
        return super.use(level, player, hand);
    }

    public void inventoryTick(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        if (!(this.getPassiveTickAbilities(itemStack).isEmpty() && this.getCooldownAbilities().isEmpty() || !(entity instanceof Player))) {
            Player player = (Player)entity;
            ToggleableTool.tickCooldowns(level, itemStack, player);
        }
    }

    protected Projectile createProjectile(Level level, LivingEntity livingEntity, ItemStack itemStack, ItemStack stack, boolean crit) {
        ArrowItem arrowitem1;
        Item item = stack.getItem();
        ArrowItem arrowitem = item instanceof ArrowItem ? (arrowitem1 = (ArrowItem)item) : (ArrowItem)Items.ARROW;
        ToggleableTool toggleableTool = (ToggleableTool)itemStack.getItem();
        if (arrowitem.equals(Items.ARROW)) {
            JustDireArrow justDireArrow = new JustDireArrow(level, livingEntity, stack, itemStack);
            if (crit) {
                justDireArrow.setCritArrow(true);
            }
            if (((Boolean)itemStack.getOrDefault(JustDireDataComponents.EPIC_ARROW, (Object)false)).booleanValue()) {
                justDireArrow.setEpicArrow(true);
                justDireArrow.setBaseDamage(20.0);
                AbilityParams abilityParams = toggleableTool.getAbilityParams(Ability.EPICARROW);
                ToggleableTool.addCooldown(itemStack, Ability.EPICARROW, abilityParams.cooldown, false);
                itemStack.set(JustDireDataComponents.EPIC_ARROW, (Object)false);
            }
            if (!toggleableTool.getEnabled(itemStack)) {
                return this.customArrow(justDireArrow, stack, itemStack);
            }
            if (this.canUseAbilityAndDurability(itemStack, Ability.PHASE)) {
                justDireArrow.setPhase(true);
                Helpers.damageTool(itemStack, livingEntity, Ability.PHASE);
            }
            if (this.canUseAbilityAndDurability(itemStack, Ability.HOMING)) {
                justDireArrow.setHoming(true);
                Helpers.damageTool(itemStack, livingEntity, Ability.HOMING);
                boolean hostileOnly = ToggleableTool.getCustomSetting(itemStack, Ability.HOMING.getName()) == 0;
                LivingEntity aimedAtEntity = this.findAimedAtEntity(livingEntity, hostileOnly, justDireArrow);
                if (aimedAtEntity != null) {
                    justDireArrow.setTargetEntity(aimedAtEntity);
                }
                justDireArrow.setHostileOnly(hostileOnly);
            }
            if (this.noPotionAbilitiesActive(itemStack)) {
                return this.customArrow(justDireArrow, stack, itemStack);
            }
            IItemHandler itemHandler = (IItemHandler)itemStack.getCapability(Capabilities.ItemHandler.ITEM);
            if (itemHandler instanceof ComponentItemHandler) {
                ComponentItemHandler componentItemHandler = (ComponentItemHandler)itemHandler;
                PotionContents potionContents = PotionContents.EMPTY;
                for (int slot = 0; slot < componentItemHandler.getSlots(); ++slot) {
                    ItemStack potionCanister = componentItemHandler.getStackInSlot(slot);
                    if (!(potionCanister.getItem() instanceof PotionCanister)) continue;
                    int potionAmt = PotionCanister.getPotionAmount(potionCanister);
                    PotionContents slotPotionContents = PotionCanister.getPotionContents(potionCanister);
                    if (slotPotionContents.equals((Object)PotionContents.EMPTY)) continue;
                    int neededAmt = 0;
                    if (this.canUseAbilityAndDurability(itemStack, Ability.POTIONARROW)) {
                        neededAmt += 25;
                    }
                    if (this.canUseAbilityAndDurability(itemStack, Ability.SPLASH)) {
                        neededAmt += 25;
                    }
                    if (this.canUseAbilityAndDurability(itemStack, Ability.LINGERING)) {
                        neededAmt += 50;
                    }
                    if (potionAmt < neededAmt) continue;
                    for (MobEffectInstance mobEffectInstance : slotPotionContents.getAllEffects()) {
                        potionContents = potionContents.withEffectAdded(mobEffectInstance);
                    }
                    PotionCanister.setPotionAmount(potionCanister, potionAmt - neededAmt);
                    componentItemHandler.setStackInSlot(slot, potionCanister);
                }
                if (!potionContents.equals((Object)PotionContents.EMPTY)) {
                    justDireArrow.setPotionContents(potionContents);
                    if (this.canUseAbilityAndDurability(itemStack, Ability.POTIONARROW)) {
                        justDireArrow.setPotionArrow(true);
                        Helpers.damageTool(itemStack, livingEntity, Ability.POTIONARROW);
                    }
                    if (this.canUseAbilityAndDurability(itemStack, Ability.SPLASH)) {
                        justDireArrow.setSplash(true);
                        Helpers.damageTool(itemStack, livingEntity, Ability.SPLASH);
                    }
                    if (this.canUseAbilityAndDurability(itemStack, Ability.LINGERING)) {
                        justDireArrow.setLingering(true);
                        Helpers.damageTool(itemStack, livingEntity, Ability.LINGERING);
                    }
                }
            }
            return this.customArrow(justDireArrow, stack, itemStack);
        }
        return super.createProjectile(level, livingEntity, itemStack, stack, crit);
    }

    public LivingEntity findAimedAtEntity(LivingEntity livingEntity, boolean onlyHostile, JustDireArrow justDireArrow) {
        double range = 50.0;
        Vec3 startVec = livingEntity.getEyePosition(1.0f);
        Vec3 lookVec = livingEntity.getViewVector(1.0f);
        Vec3 endVec = startVec.add(lookVec.scale(range));
        BlockHitResult hitResult = livingEntity.level().clip(new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity));
        if (hitResult.getType() != HitResult.Type.MISS) {
            endVec = hitResult.getLocation();
        }
        AABB boundingBox = new AABB(startVec, endVec).inflate(1.0);
        List entities = livingEntity.level().getEntities((Entity)livingEntity, boundingBox, EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        LivingEntity closestEntity = null;
        double closestDistance = range * range;
        for (Entity entity : entities) {
            double distanceToHit;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity1 = (LivingEntity)entity;
            if (onlyHostile && !justDireArrow.isHostileEntity(livingEntity1)) continue;
            AABB entityBoundingBox = entity.getBoundingBox().inflate((double)entity.getPickRadius());
            Vec3 entityHitVec = entityBoundingBox.clip(startVec, endVec).orElse(null);
            if (entityBoundingBox.contains(startVec)) {
                if (!(closestDistance >= 0.0)) continue;
                closestEntity = livingEntity1;
                closestDistance = 0.0;
                continue;
            }
            if (entityHitVec == null || !((distanceToHit = startVec.distanceToSqr(entityHitVec)) < closestDistance)) continue;
            closestEntity = livingEntity1;
            closestDistance = distanceToHit;
        }
        return closestEntity;
    }

    public boolean noPotionAbilitiesActive(ItemStack itemStack) {
        if (this.canUseAbilityAndDurability(itemStack, Ability.POTIONARROW)) {
            return false;
        }
        if (this.canUseAbilityAndDurability(itemStack, Ability.SPLASH)) {
            return false;
        }
        return !this.canUseAbilityAndDurability(itemStack, Ability.LINGERING);
    }

    protected int getDurabilityUse(ItemStack itemStack) {
        int n;
        BaseBow baseBow = this;
        if (baseBow instanceof PoweredTool) {
            PoweredTool poweredTool = (PoweredTool)((Object)baseBow);
            n = poweredTool.getBlockBreakFECost();
        } else {
            n = 1;
        }
        return n;
    }

    @Override
    public EnumSet<Ability> getAllAbilities() {
        return this.abilities;
    }

    @Override
    public EnumSet<Ability> getAbilities() {
        return this.abilities.stream().filter(ability -> (Boolean)Config.AVAILABLE_ABILITY_MAP.get(ability).get()).collect(Collectors.toCollection(() -> EnumSet.noneOf(Ability.class)));
    }

    @Override
    public Map<Ability, AbilityParams> getAbilityParamsMap() {
        return this.abilityParams;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Level level = context.level();
        if (level == null) {
            return;
        }
        boolean sneakPressed = Screen.hasShiftDown();
        TooltipHelpers.appendFEText(stack, tooltip);
        if (sneakPressed) {
            TooltipHelpers.appendToolEnabled(stack, tooltip);
            TooltipHelpers.appendAbilityList(stack, tooltip);
        } else {
            TooltipHelpers.appendToolEnabled(stack, tooltip);
            TooltipHelpers.appendShiftForInfo(stack, tooltip);
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        Item item = stack.getItem();
        if (item instanceof PoweredTool) {
            PoweredTool poweredTool = (PoweredTool)item;
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return amount;
            }
            double reductionFactor = 0.0;
            if (entity != null) {
                HolderLookup.RegistryLookup registrylookup = entity.level().getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
                int unbreakingLevel = stack.getEnchantmentLevel((Holder)registrylookup.getOrThrow(Enchantments.UNBREAKING));
                reductionFactor = Math.min(1.0, (double)unbreakingLevel * 0.1);
            }
            int finalEnergyCost = (int)Math.max(0.0, (double)amount - (double)amount * reductionFactor);
            energyStorage.extractEnergy(finalEnergyCost, false);
            return 0;
        }
        return amount;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        if (stack.getItem() instanceof PoweredTool) {
            return super.isPrimaryItemFor(stack, enchantment) && this.canAcceptEnchantments(enchantment);
        }
        return super.isPrimaryItemFor(stack, enchantment);
    }

    private boolean canAcceptEnchantments(Holder<Enchantment> enchantment) {
        return !((Enchantment)enchantment.value()).effects().has(EnchantmentEffectComponents.REPAIR_WITH_XP);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

