/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public interface PoweredTool
extends PoweredItem {
    default public ItemAttributeModifiers getPoweredAttributeModifiers(ItemStack stack, ItemAttributeModifiers originalModifiers) {
        ItemAttributeModifiers modifiers = ItemAttributeModifiers.builder().build();
        if (PoweredItem.getAvailableEnergy(stack) >= this.getBlockBreakFECost()) {
            return originalModifiers;
        }
        for (ItemAttributeModifiers.Entry entry : originalModifiers.modifiers()) {
            if (entry.attribute().equals((Object)Attributes.ATTACK_DAMAGE)) continue;
            modifiers.withModifierAdded(entry.attribute(), entry.modifier(), entry.slot());
        }
        return modifiers;
    }

    default public int getBlockBreakFECost() {
        return 50;
    }
}

