/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.entities;

import com.direwolf20.justdirethings.common.items.CreatureCatcher;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.datagen.JustDireEntityTags;
import com.direwolf20.justdirethings.setup.Registration;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.entity.PartEntity;
import org.joml.Vector3f;

public class CreatureCatcherEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Boolean> HAS_HIT = SynchedEntityData.defineId(CreatureCatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CAPTURING = SynchedEntityData.defineId(CreatureCatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> SHRINKING_TIME = SynchedEntityData.defineId(CreatureCatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ItemStack> RETURN_ITEM_STACK = SynchedEntityData.defineId(CreatureCatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Vector3f> ENTITY_POSITION = SynchedEntityData.defineId(CreatureCatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Float> ENTITY_BODY_ROT = SynchedEntityData.defineId(CreatureCatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ENTITY_HEAD_ROT = SynchedEntityData.defineId(CreatureCatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private Mob hitEntity;
    public int renderTick;

    public CreatureCatcherEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_HIT, (Object)false);
        builder.define(CAPTURING, (Object)false);
        builder.define(SHRINKING_TIME, (Object)0);
        builder.define(RETURN_ITEM_STACK, (Object)ItemStack.EMPTY);
        builder.define(ENTITY_POSITION, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        builder.define(ENTITY_BODY_ROT, (Object)Float.valueOf(0.0f));
        builder.define(ENTITY_HEAD_ROT, (Object)Float.valueOf(0.0f));
    }

    public CreatureCatcherEntity(Level pLevel, LivingEntity pShooter) {
        super((EntityType)Registration.CreatureCatcherEntity.get(), pShooter, pLevel);
    }

    public boolean hasHitEntity() {
        return (Boolean)this.entityData.get(HAS_HIT);
    }

    public boolean isCapturing() {
        return (Boolean)this.entityData.get(CAPTURING);
    }

    public ItemStack getReturnStack() {
        return (ItemStack)this.entityData.get(RETURN_ITEM_STACK);
    }

    public int shrinkingTime() {
        return (Integer)this.entityData.get(SHRINKING_TIME);
    }

    public void incrementShrinkTime() {
        this.entityData.set(SHRINKING_TIME, (Object)((Integer)this.entityData.get(SHRINKING_TIME) + 1));
    }

    public Vector3f getMobPosition() {
        return (Vector3f)this.entityData.get(ENTITY_POSITION);
    }

    public float getBodyRot() {
        return ((Float)this.entityData.get(ENTITY_BODY_ROT)).floatValue();
    }

    public int getAnimationTicks() {
        return 20;
    }

    public float getHeadRot() {
        return ((Float)this.entityData.get(ENTITY_HEAD_ROT)).floatValue();
    }

    protected Item getDefaultItem() {
        return (Item)Registration.CreatureCatcher.get();
    }

    public void tick() {
        super.tick();
        if (!this.hasHitEntity()) {
            return;
        }
        if (!this.level().isClientSide) {
            if (this.hitEntity != null && !this.hitEntity.isDeadOrDying() && this.shrinkingTime() > 1 && CreatureCatcher.hasEntity(this.getReturnStack())) {
                this.hitEntity.remove(Entity.RemovalReason.DISCARDED);
            }
            this.incrementShrinkTime();
            if (this.shrinkingTime() > this.getAnimationTicks() + 1) {
                if (this.isCapturing()) {
                    this.level().addFreshEntity((Entity)this.createItemEntity(this.getReturnStack()));
                    this.remove(Entity.RemovalReason.DISCARDED);
                } else {
                    this.releaseEntity(this.getItem());
                    this.spawnNewItemEntity();
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        } else {
            ++this.renderTick;
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Mob mob;
        super.onHitEntity(pResult);
        ItemStack itemStack = this.getItem();
        if (this.level().isClientSide || CreatureCatcher.hasEntity(itemStack)) {
            return;
        }
        Entity entity = pResult.getEntity();
        if (entity instanceof Mob && this.canCapture((Entity)(mob = (Mob)entity))) {
            this.entityData.set(HAS_HIT, (Object)true);
            this.entityData.set(CAPTURING, (Object)true);
            this.entityData.set(ENTITY_POSITION, (Object)new Vector3f((float)mob.position().x, (float)mob.position().y, (float)mob.position().z));
            this.entityData.set(ENTITY_BODY_ROT, (Object)Float.valueOf(mob.yBodyRot));
            this.entityData.set(ENTITY_HEAD_ROT, (Object)Float.valueOf(mob.yHeadRot));
            this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
            this.setNoGravity(true);
            this.captureMob(mob);
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        if (this.level().isClientSide) {
            return;
        }
        super.onHitBlock(pResult);
        ItemStack itemStack = this.getItem();
        if (CreatureCatcher.hasEntity(itemStack)) {
            this.entityData.set(HAS_HIT, (Object)true);
            this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
            this.setNoGravity(true);
        } else {
            this.spawnNewItemEntity();
        }
    }

    protected void captureMob(Mob hitEntity) {
        if (hitEntity == null) {
            return;
        }
        this.entityData.set(RETURN_ITEM_STACK, (Object)this.createItemStack(hitEntity));
        this.hitEntity = hitEntity;
    }

    protected void spawnNewItemEntity() {
        ItemEntity itemEntity = this.createItemEntity();
        this.level().addFreshEntity((Entity)itemEntity);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    protected ItemEntity createItemEntity() {
        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)this.getDefaultItem()));
        itemEntity.setPickUpDelay(10);
        return itemEntity;
    }

    protected ItemEntity createItemEntity(ItemStack itemStack) {
        ItemEntity itemEntity = this.createItemEntity();
        itemEntity.setItem(itemStack);
        return itemEntity;
    }

    protected ItemStack createItemStack(Mob entity) {
        CompoundTag entityData = new CompoundTag();
        entity.save(entityData);
        ItemStack itemStack = new ItemStack((ItemLike)this.getDefaultItem());
        itemStack.set(JustDireDataComponents.ENTITIYTYPE, (Object)EntityType.getKey((EntityType)entity.getType()).toString());
        itemStack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityData));
        return itemStack;
    }

    protected void releaseEntity(ItemStack itemStack) {
        Mob entity = CreatureCatcherEntity.getEntityFromItemStack(itemStack, this.level());
        Vec3 location = this.getPosition(0.0f);
        entity.moveTo(location);
        this.level().addFreshEntity((Entity)entity);
    }

    public static Mob getEntityFromItemStack(ItemStack itemStack, Level level) {
        if (!itemStack.has(JustDireDataComponents.ENTITIYTYPE)) {
            return null;
        }
        EntityType type = EntityType.byString((String)((String)itemStack.get(JustDireDataComponents.ENTITIYTYPE))).orElse(null);
        if (type == null) {
            return null;
        }
        Entity entity = type.create(level);
        if (!(entity instanceof Mob)) {
            return null;
        }
        if (itemStack.has(DataComponents.ENTITY_DATA)) {
            entity.load(((CustomData)itemStack.get(DataComponents.ENTITY_DATA)).copyTag());
        } else {
            entity.load(new CompoundTag());
        }
        return (Mob)entity;
    }

    protected boolean canCapture(Entity entity) {
        if (!entity.isAlive()) {
            return false;
        }
        if (entity.isMultipartEntity()) {
            return false;
        }
        if (entity instanceof PartEntity) {
            return false;
        }
        if (entity.getType().is(Tags.EntityTypes.CAPTURING_NOT_SUPPORTED)) {
            return false;
        }
        if (entity.getType().is(JustDireEntityTags.CREATURE_CATCHER_DENY)) {
            return false;
        }
        return entity.save(new CompoundTag());
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("HasHitEntity", ((Boolean)this.entityData.get(HAS_HIT)).booleanValue());
        pCompound.putBoolean("Capturing", ((Boolean)this.entityData.get(CAPTURING)).booleanValue());
        pCompound.putInt("ShrinkingTime", ((Integer)this.entityData.get(SHRINKING_TIME)).intValue());
        pCompound.put("ReturnItemStack", ((ItemStack)this.entityData.get(RETURN_ITEM_STACK)).save((HolderLookup.Provider)this.registryAccess()));
        pCompound.putFloat("EntityPosX", ((Vector3f)this.entityData.get(ENTITY_POSITION)).x());
        pCompound.putFloat("EntityPosY", ((Vector3f)this.entityData.get(ENTITY_POSITION)).y());
        pCompound.putFloat("EntityPosZ", ((Vector3f)this.entityData.get(ENTITY_POSITION)).z());
        pCompound.putFloat("EntityBodyRot", ((Float)this.entityData.get(ENTITY_BODY_ROT)).floatValue());
        pCompound.putFloat("EntityHeadRot", ((Float)this.entityData.get(ENTITY_HEAD_ROT)).floatValue());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.entityData.set(HAS_HIT, (Object)pCompound.getBoolean("HasHitEntity"));
        this.entityData.set(CAPTURING, (Object)pCompound.getBoolean("Capturing"));
        this.entityData.set(SHRINKING_TIME, (Object)pCompound.getInt("ShrinkingTime"));
        ItemStack stack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)pCompound.getCompound("ReturnItemStack")).orElseGet(() -> new ItemStack((ItemLike)this.getDefaultItem()));
        this.entityData.set(RETURN_ITEM_STACK, (Object)stack);
        Vector3f position = new Vector3f(pCompound.getFloat("EntityPosX"), pCompound.getFloat("EntityPosY"), pCompound.getFloat("EntityPosZ"));
        this.entityData.set(ENTITY_POSITION, (Object)position);
        this.entityData.set(ENTITY_BODY_ROT, (Object)Float.valueOf(pCompound.getFloat("EntityBodyRot")));
        this.entityData.set(ENTITY_HEAD_ROT, (Object)Float.valueOf(pCompound.getFloat("EntityHeadRot")));
    }
}

