/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.client.particles.itemparticle.ItemFlowParticleData;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemCollectorBE
extends BaseMachineBE
implements FilterableBE,
AreaAffectingBE,
RedstoneControlledBE {
    protected BlockCapabilityCache<IItemHandler, Direction> attachedInventory;
    public FilterData filterData = new FilterData();
    public AreaAffectingData areaAffectingData = new AreaAffectingData(((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite());
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    public boolean respectPickupDelay = false;
    public boolean showParticles = true;

    public ItemCollectorBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Registration.ItemCollectorBE.get(), pPos, pBlockState);
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public FilterData getFilterData() {
        return this.filterData;
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public AreaAffectingData getAreaAffectingData() {
        return this.areaAffectingData;
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.findItemsAndStore();
    }

    public void setSettings(boolean respectPickupDelay, boolean showParticles) {
        this.respectPickupDelay = respectPickupDelay;
        this.showParticles = showParticles;
        this.markDirtyClient();
    }

    @Override
    public FilterBasicHandler getFilterHandler() {
        return (FilterBasicHandler)((Object)this.getData(Registration.HANDLER_BASIC_FILTER));
    }

    public void doParticles(ItemStack itemStack, Vec3 sourcePos) {
        if (!this.showParticles) {
            return;
        }
        Direction direction = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        BlockPos blockPos = this.getBlockPos();
        ItemFlowParticleData data = new ItemFlowParticleData(itemStack, (double)((float)blockPos.getX() + 0.5f) - 0.3 * (double)direction.getStepX(), (double)((float)blockPos.getY() + 0.5f) - 0.3 * (double)direction.getStepY(), (double)((float)blockPos.getZ() + 0.5f) - 0.3 * (double)direction.getStepZ(), 5);
        double d0 = sourcePos.x();
        double d1 = sourcePos.y();
        double d2 = sourcePos.z();
        ((ServerLevel)this.level).sendParticles((ParticleOptions)data, d0, d1, d2, 10, 0.0, 0.0, 0.0, 0.0);
    }

    private void findItemsAndStore() {
        if (!this.isActiveRedstone() || !this.canRun()) {
            return;
        }
        assert (this.level != null);
        AABB searchArea = this.getAABB(this.getBlockPos());
        List entityList = this.level.getEntitiesOfClass(ItemEntity.class, searchArea, entity -> true).stream().toList();
        if (entityList.isEmpty()) {
            return;
        }
        IItemHandler handler = this.getAttachedInventory();
        if (handler == null) {
            return;
        }
        for (ItemEntity itemEntity : entityList) {
            ItemStack stack;
            if (this.respectPickupDelay && itemEntity.hasPickUpDelay() || (stack = itemEntity.getItem()).isEmpty() || !this.isStackValidFilter(stack)) continue;
            ItemStack leftover = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            if (leftover.isEmpty()) {
                this.doParticles(itemEntity.getItem(), itemEntity.getPosition(0.0f));
                itemEntity.remove(Entity.RemovalReason.DISCARDED);
                continue;
            }
            itemEntity.setItem(leftover);
        }
    }

    private IItemHandler getAttachedInventory() {
        if (this.attachedInventory == null) {
            assert (this.level != null);
            BlockState state = this.level.getBlockState(this.getBlockPos());
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            BlockPos inventoryPos = this.getBlockPos().relative(facing);
            this.attachedInventory = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)inventoryPos, (Object)facing.getOpposite());
        }
        return (IItemHandler)this.attachedInventory.getCapability();
    }

    @Override
    public AreaAffectingData getDefaultAreaData(AreaAffectingBE areaAffectingBE) {
        return areaAffectingBE.getDefaultAreaData(((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite());
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("respectPickupDelay", this.respectPickupDelay);
        tag.putBoolean("showParticles", this.showParticles);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.respectPickupDelay = tag.getBoolean("respectPickupDelay");
        this.showParticles = tag.getBoolean("showParticles");
    }
}

