/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidContainerData;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.common.capabilities.JustDireFluidTank;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidPlacerT1BE
extends BaseMachineBE
implements RedstoneControlledBE,
FluidMachineBE {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    public final FluidContainerData fluidContainerData;
    List<BlockPos> positionsToPlace = new ArrayList<BlockPos>();

    public FluidPlacerT1BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.MACHINE_SLOTS = 1;
        this.fluidContainerData = new FluidContainerData(this);
    }

    public FluidPlacerT1BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.FluidPlacerT1BE.get(), pPos, pBlockState);
    }

    @Override
    public int getMaxMB() {
        return 8000;
    }

    @Override
    public ContainerData getFluidContainerData() {
        return this.fluidContainerData;
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.handleItemStack();
        this.doFluidPlace();
    }

    public void handleItemStack() {
        if (this.isFull()) {
            return;
        }
        ItemStack itemStack = this.getItemStack();
        if (!this.isStackValid(itemStack)) {
            return;
        }
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        FluidStack testExtract = fluidHandlerItem.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        int insertAmt = this.getFluidTank().fill(testExtract, IFluidHandler.FluidAction.SIMULATE);
        if (insertAmt > 0) {
            FluidStack extractedStack = fluidHandlerItem.drain(insertAmt, IFluidHandler.FluidAction.EXECUTE);
            this.getFluidTank().fill(extractedStack, IFluidHandler.FluidAction.EXECUTE);
            if (itemStack.getItem() instanceof BucketItem) {
                this.getMachineHandler().setStackInSlot(0, fluidHandlerItem.getContainer());
            }
        }
    }

    public ItemStack getItemStack() {
        return this.getMachineHandler().getStackInSlot(0);
    }

    public boolean isStackValid(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandlerItem == null) {
            return false;
        }
        FluidStack fluidStack = fluidHandlerItem.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (fluidStack.getAmount() == 0) {
            return false;
        }
        return this.getFluidStack().isEmpty() || this.getFluidStack().is(fluidStack.getFluid());
    }

    public FluidStack getPlaceStack() {
        return this.getFluidTank().getFluid();
    }

    @Override
    public JustDireFluidTank getFluidTank() {
        return (JustDireFluidTank)((Object)this.getData(Registration.MACHINE_FLUID_HANDLER));
    }

    public boolean isStackValid(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return false;
        }
        return fluidStack.getAmount() >= 1000;
    }

    public boolean canPlace() {
        return true;
    }

    public boolean clearTrackerIfNeeded(FluidStack fluidStack) {
        if (this.positionsToPlace.isEmpty()) {
            return false;
        }
        if (!this.isStackValid(fluidStack)) {
            return true;
        }
        if (!this.canPlace()) {
            return true;
        }
        return !this.isActiveRedstone() && !this.redstoneControlData.redstoneMode.equals((Object)MiscHelpers.RedstoneMode.PULSE);
    }

    public void doFluidPlace() {
        FluidStack placeStack = this.getPlaceStack();
        if (!this.isStackValid(placeStack)) {
            this.getRedstoneControlData().pulsed = false;
            return;
        }
        if (this.clearTrackerIfNeeded(placeStack)) {
            this.positionsToPlace.clear();
            return;
        }
        if (!this.canPlace()) {
            return;
        }
        FakePlayer fakePlayer = this.getFakePlayer((ServerLevel)this.level);
        if (this.isActiveRedstone() && this.canRun() && this.positionsToPlace.isEmpty()) {
            this.positionsToPlace = this.findSpotsToPlace(fakePlayer);
        }
        if (this.positionsToPlace.isEmpty()) {
            return;
        }
        if (this.canRun()) {
            BlockPos blockPos = this.positionsToPlace.removeFirst();
            this.placeFluid(placeStack, blockPos);
        }
    }

    public boolean placeFluid(FluidStack fluidStack, BlockPos blockPos) {
        return FluidUtil.tryPlaceFluid(null, (Level)this.level, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)blockPos, (IFluidHandler)this.getFluidTank(), (FluidStack)fluidStack);
    }

    public boolean isBlockPosValid(BlockPos blockPos, FakePlayer fakePlayer) {
        if (!this.level.getBlockState(blockPos).canBeReplaced()) {
            return false;
        }
        Block block = this.level.getBlockState(blockPos).getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            if (this.level.getFluidState(blockPos).isSource()) {
                return false;
            }
        }
        return this.canBreakAndPlaceAt(this.level, blockPos, fakePlayer);
    }

    public List<BlockPos> findSpotsToPlace(FakePlayer fakePlayer) {
        ArrayList<BlockPos> returnList = new ArrayList<BlockPos>();
        BlockPos blockPos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
        if (this.isBlockPosValid(blockPos, fakePlayer)) {
            returnList.add(blockPos);
        }
        return returnList;
    }
}

