/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.common.containers.PotionCanisterContainer;
import com.direwolf20.justdirethings.common.items.PotionCanister;
import com.direwolf20.justdirethings.util.MagicHelpers;
import com.direwolf20.justdirethings.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;

public class PotionCanisterScreen
extends AbstractContainerScreen<PotionCanisterContainer> {
    private final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/fuelcanister.png");
    protected final ResourceLocation FLUIDBAR = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/fluidbar.png");
    ResourceLocation potionOverlay = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item/potion_overlay");
    protected final PotionCanisterContainer container;
    private ItemStack potionCanister;

    public PotionCanisterScreen(PotionCanisterContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.potionCanister = container.potionCanister;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.renderTooltip(pGuiGraphics, pX, pY);
        this.fluidBarTooltip(pGuiGraphics, pX, pY);
    }

    protected void renderSlot(GuiGraphics pGuiGraphics, Slot pSlot) {
        super.renderSlot(pGuiGraphics, pSlot);
    }

    public void init() {
        super.init();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        int offset = 5;
        guiGraphics.blit(this.FLUIDBAR, this.getGuiLeft() + offset, this.getGuiTop() + 5, 0.0f, 0.0f, 18, 72, 36, 72);
        int maxMB = PotionCanister.getMaxMB();
        int height = 70;
        if (maxMB > 0) {
            int remaining = PotionCanister.getPotionAmount(this.potionCanister) * height / maxMB;
            this.renderFluid(guiGraphics, this.getGuiLeft() + offset + 1, this.getGuiTop() + 5 + 72 - 1, 16, remaining, this.potionCanister);
        }
        guiGraphics.blit(this.FLUIDBAR, this.getGuiLeft() + offset, this.getGuiTop() + 5, 18.0f, 0.0f, 18, 72, 36, 72);
    }

    public void renderFluid(GuiGraphics guiGraphics, int startX, int startY, int width, int height, ItemStack potionCanister) {
        int drawHeight;
        PotionContents potionContents = PotionCanister.getPotionContents(potionCanister);
        if (potionContents.equals((Object)PotionContents.EMPTY) || PotionCanister.getPotionAmount(potionCanister) <= 0) {
            return;
        }
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)Fluids.WATER).getStillTexture();
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
        int fluidColor = potionContents.getColor();
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        boolean zLevel = false;
        float uMin = fluidStillSprite.getU0();
        float uMax = fluidStillSprite.getU1();
        float vMin = fluidStillSprite.getV0();
        float vMax = fluidStillSprite.getV1();
        int textureWidth = fluidStillSprite.contents().width();
        int textureHeight = fluidStillSprite.contents().height();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int yOffset = 0; yOffset < height; yOffset += drawHeight) {
            int drawWidth;
            drawHeight = Math.min(textureHeight, height - yOffset);
            int drawY = startY - yOffset - drawHeight;
            float vMaxAdjusted = vMin + (vMax - vMin) * ((float)drawHeight / (float)textureHeight);
            for (int xOffset = 0; xOffset < width; xOffset += drawWidth) {
                drawWidth = Math.min(textureWidth, width - xOffset);
                float uMaxAdjusted = uMin + (uMax - uMin) * ((float)drawWidth / (float)textureWidth);
                vertexBuffer.addVertex(poseStack.last().pose(), (float)(startX + xOffset), (float)(drawY + drawHeight), (float)zLevel).setUv(uMin, vMaxAdjusted);
                vertexBuffer.addVertex(poseStack.last().pose(), (float)(startX + xOffset + drawWidth), (float)(drawY + drawHeight), (float)zLevel).setUv(uMaxAdjusted, vMaxAdjusted);
                vertexBuffer.addVertex(poseStack.last().pose(), (float)(startX + xOffset + drawWidth), (float)drawY, (float)zLevel).setUv(uMaxAdjusted, vMin);
                vertexBuffer.addVertex(poseStack.last().pose(), (float)(startX + xOffset), (float)drawY, (float)zLevel).setUv(uMin, vMin);
            }
        }
        BufferUploader.drawWithShader((MeshData)vertexBuffer.buildOrThrow());
        poseStack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.applyModelViewMatrix();
    }

    public void fluidBarTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        PotionContents potionContents = PotionCanister.getPotionContents(this.potionCanister);
        int potionAmt = PotionCanister.getPotionAmount(this.potionCanister);
        if (potionAmt == 0 || potionContents.equals((Object)PotionContents.EMPTY)) {
            return;
        }
        if (MiscTools.inBounds(this.getGuiLeft() + 5, this.getGuiTop() + 5, 18, 72, pX, pY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(Component.literal((String)(MagicHelpers.formatted(potionAmt) + "/" + MagicHelpers.formatted(PotionCanister.getMaxMB()))));
            potionContents.addPotionTooltip(components::add, 1.0f, 20.0f);
            pGuiGraphics.renderTooltip(this.font, components, Optional.empty(), pX, pY);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        super.onClose();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double x, double y, int btn) {
        return super.mouseClicked(x, y, btn);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double pScrollX, double pScrollY) {
        return super.mouseScrolled(mouseX, mouseY, pScrollX, pScrollY);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.translatable((String)("justdirethings." + key), (Object[])args);
    }
}

