/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.client.screens.basescreens.BaseMachineScreen;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.widgets.GrayscaleButton;
import com.direwolf20.justdirethings.common.blockentities.InventoryHolderBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.containers.InventoryHolderContainer;
import com.direwolf20.justdirethings.common.containers.slots.InventoryHolderSlot;
import com.direwolf20.justdirethings.common.network.data.InventoryHolderMoveItemsPayload;
import com.direwolf20.justdirethings.common.network.data.InventoryHolderSaveSlotPayload;
import com.direwolf20.justdirethings.common.network.data.InventoryHolderSettingsPayload;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class InventoryHolderScreen
extends BaseMachineScreen<InventoryHolderContainer> {
    private InventoryHolderBE inventoryHolderBE;
    private boolean compareNBT;
    private boolean filtersOnly;
    private boolean compareCounts;
    private boolean automatedFiltersOnly;
    private boolean automatedCompareCounts;
    private boolean renderPlayer;
    private int renderedSlot;

    public InventoryHolderScreen(InventoryHolderContainer container, Inventory inv, Component name) {
        super(container, inv, name);
        BaseMachineBE baseMachineBE = container.baseMachineBE;
        if (baseMachineBE instanceof InventoryHolderBE) {
            InventoryHolderBE inventoryHolderBE;
            this.inventoryHolderBE = inventoryHolderBE = (InventoryHolderBE)baseMachineBE;
            this.compareNBT = inventoryHolderBE.compareNBT;
            this.filtersOnly = inventoryHolderBE.filtersOnly;
            this.compareCounts = inventoryHolderBE.compareCounts;
            this.automatedFiltersOnly = inventoryHolderBE.automatedFiltersOnly;
            this.automatedCompareCounts = inventoryHolderBE.automatedCompareCounts;
            this.renderPlayer = inventoryHolderBE.renderPlayer;
            this.renderedSlot = inventoryHolderBE.renderedSlot;
        }
    }

    @Override
    public void addTickSpeedButton() {
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.FILTERONLYBUTTON(this.getGuiLeft() + 134, this.topSectionTop + 22, this.filtersOnly, b -> {
            this.filtersOnly = !this.filtersOnly;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.COMPARENBTBUTTON(this.getGuiLeft() + 152, this.topSectionTop + 22, this.compareNBT, b -> {
            this.compareNBT = !this.compareNBT;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.COMPARECOUNTSBUTTON(this.getGuiLeft() + 134, this.topSectionTop + 4, this.compareCounts, b -> {
            this.compareCounts = !this.compareCounts;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.SEND_INV_BUTTON(this.getGuiLeft() + 134, this.topSectionTop + 132, b -> PacketDistributor.sendToServer((CustomPacketPayload)new InventoryHolderMoveItemsPayload(0), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.PULL_INV_BUTTON(this.getGuiLeft() + 26, this.topSectionTop + 132, b -> PacketDistributor.sendToServer((CustomPacketPayload)new InventoryHolderMoveItemsPayload(1), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.SWAP_INV_BUTTON(this.getGuiLeft() + 152, this.topSectionTop + 132, b -> PacketDistributor.sendToServer((CustomPacketPayload)new InventoryHolderMoveItemsPayload(2), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.FILTERONLYBUTTON(this.getGuiLeft() + 26, this.topSectionTop + 22, this.automatedFiltersOnly, b -> {
            this.automatedFiltersOnly = !this.automatedFiltersOnly;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.COMPARECOUNTSBUTTON(this.getGuiLeft() + 26, this.topSectionTop + 4, this.automatedCompareCounts, b -> {
            this.automatedCompareCounts = !this.automatedCompareCounts;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.SHOWFAKEPLAYERBUTTON(this.getGuiLeft() + 8, this.topSectionTop + 4, this.renderPlayer, b -> {
            this.renderPlayer = !this.renderPlayer;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
    }

    @Override
    public void setTopSection() {
        this.extraWidth = 0;
        this.extraHeight = 24;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        if (slot instanceof InventoryHolderSlot && slot.getItem().isEmpty() && !this.inventoryHolderBE.filterBasicHandler.getStackInSlot(slot.getSlotIndex()).isEmpty()) {
            ItemStack showStack = this.inventoryHolderBE.filterBasicHandler.getStackInSlot(slot.getSlotIndex());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.renderFakeItem(showStack, slot.x, slot.y);
            guiGraphics.pose().pushPose();
            guiGraphics.renderItemDecorations(Minecraft.getInstance().font, showStack, slot.x, slot.y);
            guiGraphics.pose().translate(0.0f, 0.0f, -200.0f);
            guiGraphics.fill(RenderType.guiGhostRecipeOverlay(), slot.x, slot.y, slot.x + 16, slot.y + 16, -2138535800);
            guiGraphics.pose().popPose();
            RenderSystem.disableBlend();
        } else {
            super.renderSlot(guiGraphics, slot);
        }
        if (slot.getSlotIndex() == this.renderedSlot && slot instanceof InventoryHolderSlot) {
            guiGraphics.fill(slot.x, slot.y, slot.x + 16, slot.y + 1, -65536);
            guiGraphics.fill(slot.x, slot.y + 15, slot.x + 16, slot.y + 16, -65536);
            guiGraphics.fill(slot.x, slot.y, slot.x + 1, slot.y + 16, -65536);
            guiGraphics.fill(slot.x + 15, slot.y, slot.x + 16, slot.y + 16, -65536);
        }
    }

    @Override
    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        Slot slot = this.hoveredSlot;
        if (slot instanceof InventoryHolderSlot && slot.getItem().isEmpty() && !this.inventoryHolderBE.filterBasicHandler.getStackInSlot(slot.getSlotIndex()).isEmpty()) {
            ItemStack itemstack = this.inventoryHolderBE.filterBasicHandler.getStackInSlot(slot.getSlotIndex());
            guiGraphics.renderTooltip(this.font, this.getTooltipFromContainerItem(itemstack), itemstack.getTooltipImage(), itemstack, x, y);
        } else {
            super.renderTooltip(guiGraphics, x, y);
        }
    }

    @Override
    public void saveSettings() {
        super.saveSettings();
        PacketDistributor.sendToServer((CustomPacketPayload)new InventoryHolderSettingsPayload(this.compareNBT, this.filtersOnly, this.compareCounts, this.automatedFiltersOnly, this.automatedCompareCounts, this.renderPlayer, this.renderedSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void renderInventorySection(GuiGraphics guiGraphics, int relX, int relY) {
        guiGraphics.blitSprite(this.SOCIALBACKGROUND, relX, relY + 83 - 8, this.imageWidth, this.imageHeight - 55);
    }

    @Override
    public boolean mouseClicked(double x, double y, int btn) {
        if (btn == 0 && Screen.hasControlDown() && this.hoveredSlot != null && this.hoveredSlot instanceof InventoryHolderSlot) {
            if (Screen.hasShiftDown()) {
                if (this.hoveredSlot.getSlotIndex() >= 27 && this.hoveredSlot.getSlotIndex() <= 35) {
                    this.renderedSlot = this.hoveredSlot.getSlotIndex();
                    this.saveSettings();
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    return true;
                }
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new InventoryHolderSaveSlotPayload(this.hoveredSlot.getSlotIndex()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return true;
            }
        }
        return super.mouseClicked(x, y, btn);
    }
}

