/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.client.screens.basescreens.BaseMachineScreen;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.widgets.ToggleButton;
import com.direwolf20.justdirethings.common.blockentities.BlockSwapperT1BE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.containers.BlockSwapperT2Container;
import com.direwolf20.justdirethings.common.network.data.SwapperPayload;
import com.direwolf20.justdirethings.util.MiscTools;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.GlobalPos;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class BlockSwapperT2Screen
extends BaseMachineScreen<BlockSwapperT2Container> {
    protected final ResourceLocation ACTIVE = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/active.png");
    protected final ResourceLocation INACTIVE = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/buttons/inactive.png");
    public GlobalPos boundTo;
    public BlockSwapperT1BE be;
    BlockSwapperT2Container container;
    public int swap_entity_type;
    public boolean swapBlocks;
    public int activeX;
    public int activeY;

    public BlockSwapperT2Screen(BlockSwapperT2Container container, Inventory inv, Component name) {
        super(container, inv, name);
        this.container = container;
        BaseMachineBE baseMachineBE = container.baseMachineBE;
        if (baseMachineBE instanceof BlockSwapperT1BE) {
            BlockSwapperT1BE blockSwapper = (BlockSwapperT1BE)baseMachineBE;
            this.boundTo = blockSwapper.boundTo;
            this.be = blockSwapper;
            this.swap_entity_type = blockSwapper.swap_entity_type.ordinal();
            this.swapBlocks = blockSwapper.swapBlocks;
        }
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.SWAPPERENTITYBUTTON(this.getGuiLeft() + 26, this.topSectionTop + 44, this.swap_entity_type, b -> {
            this.swap_entity_type = ((ToggleButton)b).getTexturePosition();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.SWAPPERBLOCKBUTTON(this.getGuiLeft() + 8, this.topSectionTop + 44, this.swapBlocks ? 0 : 1, b -> {
            this.swapBlocks = ((ToggleButton)b).getTexturePosition() == 0;
            this.saveSettings();
        }));
        this.activeX = this.topSectionLeft + 156;
        this.activeY = this.topSectionTop + 38;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.boundTo = this.be.boundTo;
        if (this.boundTo != null) {
            ResourceLocation icon = this.container.getPartnerExists() == 1 ? this.ACTIVE : this.INACTIVE;
            guiGraphics.blit(icon, this.activeX, this.activeY, 0.0f, 0.0f, 16, 16, 16, 16);
        } else {
            guiGraphics.blit(this.INACTIVE, this.activeX, this.activeY, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    @Override
    public void setTopSection() {
        this.extraWidth = 60;
        this.extraHeight = 0;
    }

    @Override
    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.renderTooltip(pGuiGraphics, pX, pY);
        if (MiscTools.inBounds(this.activeX, this.activeY, 16, 16, pX, pY)) {
            this.boundTo = this.be.boundTo;
            if (this.boundTo != null) {
                ChatFormatting chatFormatting = this.container.getPartnerExists() == 1 ? ChatFormatting.BLUE : ChatFormatting.DARK_RED;
                String key = this.container.getPartnerExists() == 1 ? "justdirethings.boundto" : "justdirethings.boundto-missing";
                pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)key, (Object[])new Object[]{Component.translatable((String)this.boundTo.dimension().location().getPath()), "[" + this.boundTo.pos().toShortString() + "]"}).withStyle(chatFormatting))), pX, pY);
            } else {
                ChatFormatting chatFormatting = ChatFormatting.DARK_RED;
                pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.unbound-screen").withStyle(chatFormatting))), pX, pY);
            }
        }
    }

    @Override
    public void saveSettings() {
        super.saveSettings();
        PacketDistributor.sendToServer((CustomPacketPayload)new SwapperPayload(this.swapBlocks, this.swap_entity_type), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

