/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.events;

import com.direwolf20.justdirethings.client.renderactions.MiscRenders;
import com.direwolf20.justdirethings.client.renderactions.ThingFinder;
import com.direwolf20.justdirethings.client.renderers.OurRenderTypes;
import com.direwolf20.justdirethings.client.renderers.RenderHelpers;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.util.NBTHelpers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class RenderLevelLast {
    @SubscribeEvent
    static void renderWorldLastEvent(RenderLevelStageEvent evt) {
        Object boundInventory;
        ToggleableTool toggleableTool;
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack heldItemMain = player.getMainHandItem();
        ItemStack heldItemOff = player.getOffhandItem();
        Item item = heldItemMain.getItem();
        if (item instanceof ToggleableTool) {
            toggleableTool = (ToggleableTool)item;
            ThingFinder.render(evt, (Player)player, heldItemMain);
            if (toggleableTool.canUseAbilityAndDurability(heldItemMain, Ability.VOIDSHIFT) && ToggleableTool.getCustomSetting(heldItemMain, Ability.VOIDSHIFT.getName()) == 0) {
                MiscRenders.renderTransparentPlayer(evt, (Player)player, heldItemMain);
            }
            if (toggleableTool.canUseAbility(heldItemMain, Ability.DROPTELEPORT) && ToggleableTool.getCustomSetting(heldItemMain, Ability.DROPTELEPORT.getName()) == 0 && (boundInventory = ToggleableTool.getBoundInventory(heldItemMain)) != null && player.level().dimension().equals(((NBTHelpers.BoundInventory)boundInventory).globalPos().dimension())) {
                RenderLevelLast.renderSelectedBlock(evt, ((NBTHelpers.BoundInventory)boundInventory).globalPos().pos(), ((NBTHelpers.BoundInventory)boundInventory).direction());
            }
        }
        if ((boundInventory = heldItemOff.getItem()) instanceof ToggleableTool) {
            toggleableTool = (ToggleableTool)boundInventory;
            ThingFinder.render(evt, (Player)player, heldItemOff);
            if (toggleableTool.canUseAbilityAndDurability(heldItemOff, Ability.VOIDSHIFT) && ToggleableTool.getCustomSetting(heldItemOff, Ability.VOIDSHIFT.getName()) == 0) {
                MiscRenders.renderTransparentPlayer(evt, (Player)player, heldItemOff);
            }
            if (toggleableTool.canUseAbility(heldItemOff, Ability.DROPTELEPORT) && ToggleableTool.getCustomSetting(heldItemMain, Ability.DROPTELEPORT.getName()) == 0 && (boundInventory = ToggleableTool.getBoundInventory(heldItemOff)) != null && player.level().dimension().equals(((NBTHelpers.BoundInventory)boundInventory).globalPos().dimension())) {
                RenderLevelLast.renderSelectedBlock(evt, ((NBTHelpers.BoundInventory)boundInventory).globalPos().pos(), ((NBTHelpers.BoundInventory)boundInventory).direction());
            }
        }
    }

    public static void renderSelectedBlock(RenderLevelStageEvent event, BlockPos pos, Direction direction) {
        Minecraft mc = Minecraft.getInstance();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 view = mc.gameRenderer.getMainCamera().getPosition();
        PoseStack matrix = event.getPoseStack();
        matrix.pushPose();
        matrix.translate(-view.x(), -view.y(), -view.z());
        matrix.pushPose();
        matrix.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        matrix.translate(-0.005f, -0.005f, -0.005f);
        matrix.scale(1.01f, 1.01f, 1.01f);
        Matrix4f positionMatrix = matrix.last().pose();
        RenderHelpers.renderBoxSolid(matrix, positionMatrix, (MultiBufferSource)buffer, BlockPos.ZERO, 0.0f, 1.0f, 0.0f, 0.25f);
        RenderHelpers.renderFaceSolid(matrix, positionMatrix, (MultiBufferSource)buffer, BlockPos.ZERO, direction, 0.0f, 0.0f, 1.0f, 0.25f);
        RenderHelpers.renderLines(matrix, BlockPos.ZERO, BlockPos.ZERO, Color.WHITE, (MultiBufferSource)buffer);
        matrix.popPose();
        matrix.popPose();
        buffer.endBatch(OurRenderTypes.TRANSPARENT_BOX);
    }
}

