/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.blockentityrenders;

import com.direwolf20.justdirethings.client.blockentityrenders.baseber.AreaAffectingBER;
import com.direwolf20.justdirethings.common.blockentities.ItemCollectorBE;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class ItemCollectorRenderer
extends AreaAffectingBER {
    public ItemCollectorRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    public void render(BlockEntity blockentity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        super.render(blockentity, partialTicks, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn);
        long gameTime = blockentity.getLevel().getGameTime();
        Matrix4f matrix4f = matrixStackIn.last().pose();
        if (blockentity instanceof ItemCollectorBE) {
            ItemCollectorBE itemCollectorBE = (ItemCollectorBE)blockentity;
            this.renderCube(itemCollectorBE, matrix4f, bufferIn.getBuffer(this.renderType()), gameTime, partialTicks);
        }
    }

    private void renderCube(ItemCollectorBE blockEntity, Matrix4f matrixStack, VertexConsumer vertexConsumer, long gameTime, float partialTicks) {
        Direction direction = ((Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite();
        float oneSmall = 0.53125f;
        float zeroSmall = 0.46875f;
        float oneBig = 0.5625f;
        float zeroBig = 0.4375f;
        int animationDuration = 80;
        float animationTick = (float)Math.floorMod(gameTime, animationDuration) + partialTicks;
        float lerp = Mth.cos((float)(animationTick / (float)animationDuration * ((float)Math.PI * 2))) * 0.25f + 0.25f;
        float zero = Mth.lerp((float)lerp, (float)zeroSmall, (float)zeroBig);
        float one = Mth.lerp((float)lerp, (float)oneSmall, (float)oneBig);
        float diff = one - zero;
        switch (direction) {
            case UP: {
                float f = 0.75f;
                this.renderFace(matrixStack, vertexConsumer, zero, one, f, f + diff, one, one, one, one);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f + diff, f, zero, zero, zero, zero);
                this.renderFace(matrixStack, vertexConsumer, one, one, f + diff, f, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, zero, zero, f, f + diff, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f, f, zero, zero, one, one);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f + diff, f + diff, one, one, zero, zero);
                break;
            }
            case DOWN: {
                float f = 0.25f;
                this.renderFace(matrixStack, vertexConsumer, zero, one, f, f - diff, one, one, one, one);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f - diff, f, zero, zero, zero, zero);
                this.renderFace(matrixStack, vertexConsumer, one, one, f - diff, f, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, zero, zero, f, f - diff, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f, f, zero, zero, one, one);
                this.renderFace(matrixStack, vertexConsumer, zero, one, f - diff, f - diff, one, one, zero, zero);
                break;
            }
            case NORTH: {
                float f = 0.25f;
                this.renderFace(matrixStack, vertexConsumer, zero, one, zero, one, f, f, f, f);
                this.renderFace(matrixStack, vertexConsumer, zero, one, one, zero, f - diff, f - diff, f - diff, f - diff);
                this.renderFace(matrixStack, vertexConsumer, one, one, one, zero, f - diff, f, f, f - diff);
                this.renderFace(matrixStack, vertexConsumer, zero, zero, zero, one, f - diff, f, f, f - diff);
                this.renderFace(matrixStack, vertexConsumer, zero, one, zero, zero, f - diff, f - diff, f, f);
                this.renderFace(matrixStack, vertexConsumer, zero, one, one, one, f, f, f - diff, f - diff);
                break;
            }
            case SOUTH: {
                float f = 0.75f;
                this.renderFace(matrixStack, vertexConsumer, zero, one, zero, one, f, f, f, f);
                this.renderFace(matrixStack, vertexConsumer, zero, one, one, zero, f + diff, f + diff, f + diff, f + diff);
                this.renderFace(matrixStack, vertexConsumer, zero, zero, zero, one, f + diff, f, f, f + diff);
                this.renderFace(matrixStack, vertexConsumer, one, one, one, zero, f + diff, f, f, f + diff);
                this.renderFace(matrixStack, vertexConsumer, zero, one, one, one, f, f, f + diff, f + diff);
                this.renderFace(matrixStack, vertexConsumer, zero, one, zero, zero, f + diff, f + diff, f, f);
                break;
            }
            case EAST: {
                float f = 0.75f;
                this.renderFace(matrixStack, vertexConsumer, f, f + diff, zero, one, one, one, one, one);
                this.renderFace(matrixStack, vertexConsumer, f, f + diff, one, zero, zero, zero, zero, zero);
                this.renderFace(matrixStack, vertexConsumer, f + diff, f + diff, one, zero, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, f, f, zero, one, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, f, f + diff, zero, zero, zero, zero, one, one);
                this.renderFace(matrixStack, vertexConsumer, f, f + diff, one, one, one, one, zero, zero);
                break;
            }
            case WEST: {
                float f = 0.25f;
                this.renderFace(matrixStack, vertexConsumer, f, f - diff, zero, one, one, one, one, one);
                this.renderFace(matrixStack, vertexConsumer, f, f - diff, one, zero, zero, zero, zero, zero);
                this.renderFace(matrixStack, vertexConsumer, f, f, zero, one, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, f - diff, f - diff, one, zero, zero, one, one, zero);
                this.renderFace(matrixStack, vertexConsumer, f, f - diff, one, one, one, one, zero, zero);
                this.renderFace(matrixStack, vertexConsumer, f, f - diff, zero, zero, zero, zero, one, one);
                break;
            }
        }
    }

    private void renderFace(Matrix4f matrixStack, VertexConsumer vertexConsumer, float x1, float x2, float y1, float y2, float z1, float z2, float z3, float z4) {
        vertexConsumer.addVertex(matrixStack, x1, y1, z1);
        vertexConsumer.addVertex(matrixStack, x2, y1, z2);
        vertexConsumer.addVertex(matrixStack, x2, y2, z3);
        vertexConsumer.addVertex(matrixStack, x1, y2, z4);
    }

    protected RenderType renderType() {
        return RenderType.endPortal();
    }
}

