/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.item.crafting.CokeOvenRecipe;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.entity.CokeOvenBlockEntity;
import mods.railcraft.world.level.material.RailcraftFluids;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.CookingModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class CokeOvenModule
extends CookingModule<CokeOvenRecipe, CokeOvenBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int SLOT_LIQUID_INPUT = 2;
    public static final int SLOT_LIQUID_PROCESSING = 3;
    public static final int SLOT_LIQUID_OUTPUT = 4;
    private final ContainerMapper outputContainer;
    private int multiplier = 1;
    private final StandardTank tank;
    private int fluidProcessingTimer;
    private FluidTools.ProcessState processState = FluidTools.ProcessState.RESET;
    private final ContainerMapper fluidContainer;
    private final IItemHandler itemHandler;

    public CokeOvenModule(CokeOvenBlockEntity provider) {
        super(provider, 5, 0);
        this.tank = StandardTank.ofBuckets(64).disableFill().changeCallback(this::setChanged);
        this.outputContainer = ContainerMapper.make(this, 1, 1).ignoreItemChecks();
        this.fluidContainer = ContainerMapper.make(this, 2, 4);
        this.itemHandler = new InvWrapper(this, this){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 0) {
                    return ItemStack.EMPTY;
                }
                return super.extractItem(slot, amount, simulate);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (slot == 0) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
    }

    @Override
    protected RecipeType<CokeOvenRecipe> getRecipeType() {
        return (RecipeType)RailcraftRecipeTypes.COKING.get();
    }

    @Override
    protected boolean craftAndPush() {
        boolean crafted = false;
        for (int i = 0; i < this.multiplier; ++i) {
            crafted |= this.craftAndPushImp();
        }
        return crafted;
    }

    private boolean craftAndPushImp() {
        ItemStack output = ((CokeOvenRecipe)this.recipe).getResultItem((HolderLookup.Provider)((CokeOvenBlockEntity)this.provider).level().registryAccess());
        FluidStack fluidOutput = ((CokeOvenRecipe)this.recipe).getCreosote();
        if (this.outputContainer.canFit(output) && (fluidOutput.isEmpty() || this.tank.internalFill(fluidOutput, IFluidHandler.FluidAction.SIMULATE) >= fluidOutput.getAmount())) {
            this.removeItem(0, 1);
            this.outputContainer.insert(output);
            this.tank.internalFill(fluidOutput, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    @Override
    public void serverTick() {
        ItemStack bottomSlot;
        super.serverTick();
        ItemStack topSlot = this.getItem(2);
        if (!topSlot.isEmpty() && !FluidTools.isFluidHandler(topSlot)) {
            this.setItem(2, ItemStack.EMPTY);
            ((CokeOvenBlockEntity)this.provider).dropItem(topSlot);
        }
        if (!(bottomSlot = this.getItem(4)).isEmpty() && !FluidTools.isFluidHandler(bottomSlot)) {
            this.setItem(4, ItemStack.EMPTY);
            ((CokeOvenBlockEntity)this.provider).dropItem(bottomSlot);
        }
        if (this.fluidProcessingTimer++ >= 8) {
            this.fluidProcessingTimer = 0;
            this.processState = FluidTools.processContainer(this.fluidContainer, this.tank, FluidTools.ProcessType.FILL_ONLY, this.processState);
        }
    }

    public boolean needsFuel() {
        return this.getItem(0).getCount() < 8;
    }

    public StandardTank getTank() {
        return this.tank;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        switch (slot) {
            case 0: {
                if (!this.getRecipeFor(itemStack).isPresent()) return false;
                break;
            }
            case 2: {
                if (!FluidTools.isRoomInContainer(itemStack, (Fluid)RailcraftFluids.CREOSOTE.get())) return false;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        if (!super.canPlaceItem(slot, itemStack)) return false;
        return true;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
        tag.putString("processState", this.processState.getSerializedName());
        return tag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        super.deserializeNBT(provider, tag);
        this.tank.readFromNBT(provider, tag.getCompound("tank"));
        this.processState = FluidTools.ProcessState.fromTag(tag);
    }
}

