/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.BlastFurnaceRecipe;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.entity.BlastFurnaceBlockEntity;
import mods.railcraft.world.module.CookingModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class BlastFurnaceModule
extends CookingModule<BlastFurnaceRecipe, BlastFurnaceBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_SLAG = 3;
    private static final int FUEL_PER_TICK = 5;
    private final ContainerMapper fuelContainer = ContainerMapper.make(this, 1, 1);
    private final ContainerMapper outputContainer = ContainerMapper.make(this, 2, 1).ignoreItemChecks();
    private final ContainerMapper slagContainer = ContainerMapper.make(this, 3, 1).ignoreItemChecks();
    private final IItemHandler itemHandler = new InvWrapper(this, this){

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 || slot == 1) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot == 0 || slot == 1) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private int burnTime;
    private int currentItemBurnTime;

    public BlastFurnaceModule(BlastFurnaceBlockEntity provider) {
        super(provider, 4, 0);
    }

    public ContainerManipulator<?> getFuelContainer() {
        return this.fuelContainer;
    }

    public int getCurrentItemBurnTime() {
        return this.currentItemBurnTime;
    }

    public void setCurrentItemBurnTime(int currentItemBurnTime) {
        this.currentItemBurnTime = currentItemBurnTime;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    @Override
    public void serverTick() {
        super.serverTick();
        this.setBurnTime(this.burnTime - 5);
    }

    @Override
    protected RecipeType<BlastFurnaceRecipe> getRecipeType() {
        return (RecipeType)RailcraftRecipeTypes.BLASTING.get();
    }

    @Override
    protected boolean doProcessStep() {
        this.loadFuel();
        return this.isBurning();
    }

    @Override
    protected boolean craftAndPush() {
        ItemStack output = ((BlastFurnaceRecipe)this.recipe).getResultItem((HolderLookup.Provider)((BlastFurnaceBlockEntity)this.provider).level().registryAccess());
        if (!this.outputContainer.canFit(output)) {
            return false;
        }
        ItemStack nextSlag = ((Item)RailcraftItems.SLAG.get()).getDefaultInstance();
        nextSlag.setCount(((BlastFurnaceRecipe)this.recipe).getSlagOutput());
        if (!this.slagContainer.canFit(nextSlag)) {
            return false;
        }
        this.outputContainer.insert(output);
        this.slagContainer.insert(nextSlag);
        this.removeItem(0, 1);
        this.setProgress(0);
        return true;
    }

    private int getItemBurnTime(ItemStack itemStack) {
        return itemStack.getBurnTime(null);
    }

    private void loadFuel() {
        ItemStack fuel;
        if (this.burnTime > 10 || (fuel = this.getItem(1)).isEmpty()) {
            return;
        }
        int itemBurnTime = this.getItemBurnTime(fuel);
        if (itemBurnTime <= 0) {
            return;
        }
        this.currentItemBurnTime = itemBurnTime + this.burnTime;
        this.setBurnTime(this.currentItemBurnTime);
        ItemStack craftRemainder = fuel.getCraftingRemainingItem();
        fuel.shrink(1);
        this.setItem(1, fuel.isEmpty() ? craftRemainder : fuel);
    }

    public void setBurnTime(int burnTime) {
        burnTime = Math.max(0, burnTime);
        boolean wasBurning = this.isBurning();
        this.burnTime = burnTime;
        if (wasBurning != this.isBurning()) {
            ((BlastFurnaceBlockEntity)this.provider).syncToClient();
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public int getBurnProgressScaled(int scale) {
        if (this.burnTime <= 0 || this.currentItemBurnTime <= 0) {
            return 0;
        }
        return Mth.clamp((int)(this.burnTime * scale / this.currentItemBurnTime), (int)0, (int)scale);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        switch (slot) {
            case 0: {
                if (!this.getRecipeFor(itemStack).isPresent()) return false;
                break;
            }
            case 1: {
                if (!this.isFuel(itemStack)) return false;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                return false;
            }
        }
        if (!super.canPlaceItem(slot, itemStack)) return false;
        return true;
    }

    public boolean isFuel(ItemStack itemStack) {
        return this.getItemBurnTime(itemStack) > 0;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.putInt("burnTime", this.burnTime);
        tag.putInt("currentItemBurnTime", this.currentItemBurnTime);
        return tag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        super.deserializeNBT(provider, tag);
        this.burnTime = tag.getInt("burnTime");
        this.currentItemBurnTime = tag.getInt("currentItemBurnTime");
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeVarInt(this.burnTime);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.setBurnTime(in.readVarInt());
    }
}

