/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.levelgen.structure;

import mods.railcraft.world.level.block.DecorativeBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.levelgen.structure.RailcraftStructurePieces;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class GeodeStructurePiece
extends StructurePiece {
    private static final int DISTANCE_OUTER_SQ = 64;
    private static final int DISTANCE_ORE_SQ = 25;
    private static final int DISTANCE_INNER_SQ = 16;

    public GeodeStructurePiece(int minX, int y, int minZ) {
        super((StructurePieceType)RailcraftStructurePieces.GEODE.get(), 0, GeodeStructurePiece.createBoundingBox(minX, y, minZ));
        this.setOrientation(null);
    }

    public GeodeStructurePiece(CompoundTag tag) {
        super((StructurePieceType)RailcraftStructurePieces.GEODE.get(), tag);
    }

    private static BoundingBox createBoundingBox(int minX, int y, int minZ) {
        return new BoundingBox(minX, y, minZ, minX + 16, y + 16, minZ + 16);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
    }

    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        for (int x = -8; x < 8; ++x) {
            for (int y = -8; y < 8; ++y) {
                for (int z = -8; z < 8; ++z) {
                    int distSq = x * x + y * y + z * z;
                    BlockPos targetPos = pos.offset(x, 9 + y, z);
                    if (distSq <= 16) {
                        this.placeAir(level, targetPos);
                    } else if (distSq <= 64) {
                        this.placeStone(level, targetPos, random);
                    }
                    BlockState existingState = level.getBlockState(targetPos);
                    if (distSq <= 16 || distSq > 25) continue;
                    this.placeOre(level, existingState, random, targetPos);
                }
            }
        }
    }

    private void placeAir(WorldGenLevel level, BlockPos pos) {
        this.placeBlock(level, Blocks.AIR.defaultBlockState(), pos.getX(), pos.getY(), pos.getZ(), this.getBoundingBox());
    }

    private void placeStone(WorldGenLevel level, BlockPos pos, RandomSource random) {
        BlockState state = random.nextDouble() < 0.2 ? (random.nextBoolean() ? Blocks.DEEPSLATE.defaultBlockState() : Blocks.SMOOTH_BASALT.defaultBlockState()) : ((Block)RailcraftBlocks.DECORATIVE_STONE.variantFor(DecorativeBlock.ABYSSAL).get()).defaultBlockState();
        this.placeBlock(level, state, pos.getX(), pos.getY(), pos.getZ(), this.getBoundingBox());
    }

    private void placeOre(WorldGenLevel level, BlockState existingState, RandomSource random, BlockPos pos) {
        if (existingState.is((Block)RailcraftBlocks.DECORATIVE_STONE.variantFor(DecorativeBlock.ABYSSAL).get())) {
            double chance = random.nextDouble();
            BlockState oreState = null;
            if (chance <= 0.004) {
                oreState = Blocks.DEEPSLATE_DIAMOND_ORE.defaultBlockState();
            } else if (chance <= 0.008) {
                oreState = Blocks.DEEPSLATE_EMERALD_ORE.defaultBlockState();
            } else if (chance <= 0.02) {
                oreState = Blocks.DEEPSLATE_LAPIS_ORE.defaultBlockState();
            }
            if (oreState != null) {
                this.placeBlock(level, oreState, pos.getX(), pos.getY(), pos.getZ(), this.getBoundingBox());
            }
        }
    }
}

