/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.function.Supplier;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.track.outfitted.OutfittedTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public class ReversibleOutfittedTrackBlock
extends OutfittedTrackBlock {
    public static final BooleanProperty REVERSED = BooleanProperty.create((String)"reversed");

    public ReversibleOutfittedTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).setValue((Property)REVERSED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{REVERSED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)REVERSED, (Comparable)Boolean.valueOf(context.getHorizontalDirection() == Direction.SOUTH || context.getHorizontalDirection() == Direction.WEST));
    }

    @Override
    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return rotation == Rotation.CLOCKWISE_180 ? (BlockState)blockState.cycle((Property)REVERSED) : blockState;
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        return level.setBlockAndUpdate(pos, (BlockState)blockState.cycle((Property)REVERSED));
    }

    public static boolean isReversed(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)REVERSED);
    }

    public static Direction getFacing(BlockState blockState) {
        return ReversibleOutfittedTrackBlock.getDirection(ReversibleOutfittedTrackBlock.getRailShapeRaw(blockState), ReversibleOutfittedTrackBlock.isReversed(blockState));
    }

    public static Direction getDirection(RailShape railShape, boolean reversed) {
        return railShape == RailShape.NORTH_SOUTH ? (reversed ? Direction.SOUTH : Direction.NORTH) : (reversed ? Direction.WEST : Direction.EAST);
    }
}

