/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.post;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.VoxelShapeUtil;
import mods.railcraft.world.level.block.post.Column;
import mods.railcraft.world.level.block.post.Connection;
import mods.railcraft.world.level.block.signal.SignalBlock;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PostBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final VoxelShape TOP_COLUMN_SHAPE = PostBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape MIDDLE_COLUMN_SHAPE = PostBlock.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
    public static final VoxelShape FULL_COLUMN_SHAPE = PostBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape PLATFORM_SHAPE = Shapes.or((VoxelShape)PostBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)PostBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public static final Map<Direction, VoxelShape> HORIZONTAL_CONNECTION_SHAPES = Map.copyOf(VoxelShapeUtil.createHorizontalShapes(7.0, 7.0, 7.0, 9.0, 15.0, 9.0));
    public static final EnumProperty<Column> COLUMN = EnumProperty.create((String)"column", Column.class);
    public static final EnumProperty<Connection> NORTH = EnumProperty.create((String)"north", Connection.class);
    public static final EnumProperty<Connection> SOUTH = EnumProperty.create((String)"south", Connection.class);
    public static final EnumProperty<Connection> EAST = EnumProperty.create((String)"east", Connection.class);
    public static final EnumProperty<Connection> WEST = EnumProperty.create((String)"west", Connection.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final Map<Direction, EnumProperty<Connection>> propertyByDirection = (Map)Util.make(new EnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    });
    private final Map<Column, VoxelShape[]> shapes = Map.of(Column.FULL, VoxelShapeUtil.makeShapes(FULL_COLUMN_SHAPE, HORIZONTAL_CONNECTION_SHAPES), Column.TOP, VoxelShapeUtil.makeShapes(TOP_COLUMN_SHAPE, HORIZONTAL_CONNECTION_SHAPES), Column.SMALL, VoxelShapeUtil.makeShapes(MIDDLE_COLUMN_SHAPE, HORIZONTAL_CONNECTION_SHAPES), Column.PLATFORM, VoxelShapeUtil.makeShapes(PLATFORM_SHAPE, HORIZONTAL_CONNECTION_SHAPES));
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();

    public PostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        properties.strength(3.0f, 15.0f);
        for (BlockState blockstate : this.stateDefinition.getPossibleStates()) {
            this.getShapeIndex(blockstate);
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(COLUMN, (Comparable)((Object)Column.FULL))).setValue(NORTH, (Comparable)((Object)Connection.NONE))).setValue(SOUTH, (Comparable)((Object)Connection.NONE))).setValue(EAST, (Comparable)((Object)Connection.NONE))).setValue(WEST, (Comparable)((Object)Connection.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLUMN, NORTH, SOUTH, EAST, WEST, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return this.shapes.get(blockState.getValue(COLUMN))[this.getShapeIndex(blockState)];
    }

    public VoxelShape getBlockSupportShape(BlockState blockState, BlockGetter level, BlockPos blockPos) {
        return Shapes.block();
    }

    public final int getShapeIndex(BlockState blockState) {
        return this.stateToIndex.computeIfAbsent((Object)blockState, this::computeShapeIndex);
    }

    protected int computeShapeIndex(BlockState blockState) {
        int i = 0;
        for (Map.Entry<Direction, EnumProperty<Connection>> entry : propertyByDirection.entrySet()) {
            if (blockState.getValue((Property)entry.getValue()) == Connection.NONE) continue;
            i |= VoxelShapeUtil.indexFor(entry.getKey());
        }
        switch ((Column)((Object)blockState.getValue(COLUMN))) {
            case FULL: {
                i |= VoxelShapeUtil.indexFor(Direction.DOWN);
            }
            case TOP: {
                i |= VoxelShapeUtil.indexFor(Direction.UP);
                break;
            }
        }
        return i;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (level.isClientSide()) {
            return itemStack.is(Items.LEAD) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return LeadItem.bindPlayerMobs((Player)player, (Level)level, (BlockPos)pos) == InteractionResult.SUCCESS ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        FluidState fluidState = level.getFluidState(context.getClickedPos());
        BlockPos northPos = blockPos.north();
        BlockPos eastPos = blockPos.east();
        BlockPos southPos = blockPos.south();
        BlockPos westPos = blockPos.west();
        BlockState northState = level.getBlockState(northPos);
        BlockState eastState = level.getBlockState(eastPos);
        BlockState southState = level.getBlockState(southPos);
        BlockState westState = level.getBlockState(westPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue(COLUMN, (Comparable)((Object)this.getColumn((BlockGetter)level, blockPos)))).setValue(NORTH, (Comparable)((Object)this.getConnection(northState, northState.isFaceSturdy((BlockGetter)level, northPos, Direction.SOUTH), Direction.SOUTH)))).setValue(EAST, (Comparable)((Object)this.getConnection(eastState, eastState.isFaceSturdy((BlockGetter)level, eastPos, Direction.WEST), Direction.WEST)))).setValue(SOUTH, (Comparable)((Object)this.getConnection(southState, southState.isFaceSturdy((BlockGetter)level, southPos, Direction.NORTH), Direction.NORTH)))).setValue(WEST, (Comparable)((Object)this.getConnection(westState, westState.isFaceSturdy((BlockGetter)level, westPos, Direction.EAST), Direction.EAST)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType().isSame((Fluid)Fluids.WATER)));
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos blockPos, BlockPos neighborPos) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return direction.getAxis().getPlane() == Direction.Plane.HORIZONTAL ? (BlockState)blockState.setValue((Property)propertyByDirection.get(direction), (Comparable)((Object)this.getConnection(neighborState, neighborState.isFaceSturdy((BlockGetter)level, neighborPos, direction.getOpposite()), direction.getOpposite()))) : (BlockState)blockState.setValue(COLUMN, (Comparable)((Object)this.getColumn((BlockGetter)level, blockPos)));
    }

    public Connection getConnection(BlockState blockState, boolean sturdy, Direction direction) {
        if (blockState.is(RailcraftTags.Blocks.SIGNAL)) {
            return SignalBlock.connectsToDirection(blockState, direction.getOpposite()) ? Connection.DOUBLE : Connection.NONE;
        }
        if (blockState.is(RailcraftTags.Blocks.POST) || !PostBlock.isExceptionForConnection((BlockState)blockState) && sturdy) {
            return Connection.DOUBLE;
        }
        return Connection.NONE;
    }

    public Column getColumn(BlockGetter level, BlockPos blockPos) {
        BlockPos abovePos = blockPos.above();
        BlockState aboveState = level.getBlockState(abovePos);
        BlockPos belowPos = blockPos.below();
        BlockState belowState = level.getBlockState(belowPos);
        if (aboveState.is(BlockTags.RAILS)) {
            return Column.PLATFORM;
        }
        if (belowState.is(RailcraftTags.Blocks.POST) || belowState.is(RailcraftTags.Blocks.SIGNAL) || belowState.isFaceSturdy(level, belowPos, Direction.UP)) {
            return Column.FULL;
        }
        if (!aboveState.isAir()) {
            return Column.TOP;
        }
        return Column.SMALL;
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter level, BlockPos pos) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) == false;
    }

    public FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathType) {
        return false;
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue(NORTH, (Comparable)((Object)((Connection)((Object)blockState.getValue(SOUTH)))))).setValue(EAST, (Comparable)((Object)((Connection)((Object)blockState.getValue(WEST)))))).setValue(SOUTH, (Comparable)((Object)((Connection)((Object)blockState.getValue(NORTH)))))).setValue(WEST, (Comparable)((Object)((Connection)((Object)blockState.getValue(EAST)))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue(NORTH, (Comparable)((Object)((Connection)((Object)blockState.getValue(EAST)))))).setValue(EAST, (Comparable)((Object)((Connection)((Object)blockState.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((Connection)((Object)blockState.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((Connection)((Object)blockState.getValue(NORTH)))));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue(NORTH, (Comparable)((Object)((Connection)((Object)blockState.getValue(WEST)))))).setValue(EAST, (Comparable)((Object)((Connection)((Object)blockState.getValue(NORTH)))))).setValue(SOUTH, (Comparable)((Object)((Connection)((Object)blockState.getValue(EAST)))))).setValue(WEST, (Comparable)((Object)((Connection)((Object)blockState.getValue(SOUTH)))));
            }
        }
        return blockState;
    }

    public BlockState mirror(BlockState blockState, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)blockState.setValue(NORTH, (Comparable)((Object)((Connection)((Object)blockState.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((Connection)((Object)blockState.getValue(NORTH)))));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)blockState.setValue(EAST, (Comparable)((Object)((Connection)((Object)blockState.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((Connection)((Object)blockState.getValue(EAST)))));
            }
        }
        return super.mirror(blockState, mirror);
    }
}

