/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.gui.button.ButtonState;
import mods.railcraft.util.RedstoneUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SignalCapacitorBoxBlockEntity
extends AbstractSignalBoxBlockEntity {
    private short ticksPowered;
    private short ticksToPower = (short)200;
    private SignalAspect signalAspect = SignalAspect.OFF;
    private Mode mode = Mode.RISING_EDGE;

    public SignalCapacitorBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.SIGNAL_CAPACITOR_BOX.get(), blockPos, blockState);
    }

    public short getTicksToPower() {
        return this.ticksToPower;
    }

    public void setTicksToPower(short ticksToPower) {
        this.ticksToPower = ticksToPower;
        this.setChanged();
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.setChanged();
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, SignalCapacitorBoxBlockEntity blockEntity) {
        short s = blockEntity.ticksPowered;
        blockEntity.ticksPowered = (short)(s - 1);
        if (s > 0) {
            if (blockEntity.mode == Mode.FALLING_EDGE) {
                SignalAspect signalAspect = SignalAspect.GREEN;
                boolean powered = RedstoneUtil.hasRepeaterSignal(level, blockPos);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    AbstractSignalBoxBlockEntity box;
                    BlockEntity neighbor = level.getBlockEntity(blockPos.relative(direction));
                    if (!(neighbor instanceof AbstractSignalBoxBlockEntity) || (box = (AbstractSignalBoxBlockEntity)neighbor).getRedstoneSignal(direction.getOpposite()) <= 0) continue;
                    powered = true;
                    signalAspect = SignalAspect.mostRestrictive(signalAspect, box.getSignalAspect(direction.getOpposite()));
                }
                if (powered) {
                    blockEntity.ticksPowered = blockEntity.ticksToPower;
                    if (blockEntity.signalAspect != signalAspect) {
                        blockEntity.signalAspect = signalAspect;
                        blockEntity.setChanged();
                    }
                }
            }
            if (blockEntity.ticksPowered <= 0) {
                blockEntity.setChanged();
            }
        }
    }

    @Override
    public void setChanged() {
        super.setChanged();
        this.syncToClient();
    }

    @Override
    public void neighborChanged() {
        if (this.level.isClientSide()) {
            return;
        }
        boolean powered = RedstoneUtil.hasRepeaterSignal(this.level, this.getBlockPos());
        if (this.ticksPowered <= 0 && powered) {
            this.ticksPowered = this.ticksToPower;
            if (this.mode == Mode.RISING_EDGE) {
                this.signalAspect = SignalAspect.GREEN;
            }
            this.setChanged();
        }
    }

    @Override
    public void neighborSignalBoxChanged(AbstractSignalBoxBlockEntity neighbor, Direction direction, boolean removed) {
        if (neighbor.getRedstoneSignal(direction) > 0) {
            this.ticksPowered = this.ticksToPower;
            SignalAspect newSignalAspect = this.signalAspect;
            if (this.mode == Mode.RISING_EDGE) {
                newSignalAspect = neighbor.getSignalAspect(direction);
            }
            if (newSignalAspect != this.signalAspect) {
                this.signalAspect = newSignalAspect;
                this.setChanged();
            }
        }
    }

    @Override
    public int getRedstoneSignal(Direction direction) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(direction.getOpposite()));
        return blockEntity instanceof AbstractSignalBoxBlockEntity || this.ticksPowered <= 0 ? 0 : 15;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putShort("ticksPowered", this.ticksPowered);
        tag.putShort("ticksToPower", this.ticksToPower);
        tag.putString("signalAspect", this.signalAspect.getSerializedName());
        tag.putString("mode", this.mode.getSerializedName());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.ticksPowered = tag.getShort("ticksPowered");
        this.ticksToPower = tag.getShort("ticksToPower");
        this.signalAspect = SignalAspect.fromName(tag.getString("signalAspect")).orElse(SignalAspect.OFF);
        this.mode = Mode.fromName(tag.getString("mode"));
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeBoolean(this.ticksPowered > 0);
        data.writeShort((int)this.ticksToPower);
        data.writeEnum((Enum)this.signalAspect);
        data.writeEnum((Enum)this.mode);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.ticksPowered = (short)(data.readBoolean() ? 1 : 0);
        this.ticksToPower = data.readShort();
        this.signalAspect = (SignalAspect)data.readEnum(SignalAspect.class);
        this.mode = (Mode)data.readEnum(Mode.class);
    }

    @Override
    public SignalAspect getSignalAspect(Direction direction) {
        return this.ticksPowered > 0 ? this.signalAspect : SignalAspect.RED;
    }

    public static enum Mode implements ButtonState<Mode>,
    StringRepresentable
    {
        RISING_EDGE("rising_edge"),
        FALLING_EDGE("falling_edge");

        private static final StringRepresentable.EnumCodec<Mode> CODEC;
        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        @Override
        public Component label() {
            return Component.translatable((String)this.getTranslationKey());
        }

        @Override
        public Optional<Component> tooltip() {
            return Optional.of(Component.translatable((String)this.getDescriptionKey()));
        }

        public String getTranslationKey() {
            return Translations.makeKey("signal", "capacitor." + this.name);
        }

        public String getDescriptionKey() {
            return this.getTranslationKey() + ".desc";
        }

        public String getSerializedName() {
            return this.name;
        }

        @Override
        public TexturePosition texturePosition() {
            return ButtonTexture.SMALL_BUTTON;
        }

        @Override
        public Mode next() {
            return (Mode)EnumUtil.next((Enum)this, (Enum[])Mode.values());
        }

        public static Mode fromName(String name) {
            return (Mode)CODEC.byName(name, (Enum)RISING_EDGE);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
        }
    }
}

