/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.tunnelbore;

import mods.railcraft.Translations;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.entity.vehicle.TunnelBore;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;

public class TunnelBoreItem
extends Item
implements JeiSearchable {
    public TunnelBoreItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState existingState = level.getBlockState(pos = context.getClickedPos());
        if (BaseRailBlock.isRail((BlockState)existingState)) {
            RailShape trackShape;
            if (!level.isClientSide() && EntitySearcher.findMinecarts().at(pos).list(level).isEmpty() && RailShapeUtil.isLevelStraight(trackShape = TrackUtil.getTrackDirection((BlockGetter)level, pos, existingState))) {
                Direction playerFacing = context.getHorizontalDirection().getOpposite();
                if (trackShape == RailShape.NORTH_SOUTH) {
                    if (playerFacing == Direction.WEST) {
                        playerFacing = Direction.NORTH;
                    } else if (playerFacing == Direction.EAST) {
                        playerFacing = Direction.SOUTH;
                    }
                } else if (trackShape == RailShape.EAST_WEST) {
                    if (playerFacing == Direction.SOUTH) {
                        playerFacing = Direction.EAST;
                    } else if (playerFacing == Direction.NORTH) {
                        playerFacing = Direction.WEST;
                    }
                }
                TunnelBore bore = new TunnelBore(level, (double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), playerFacing);
                level.addFreshEntity((Entity)bore);
            }
            context.getItemInHand().shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public Component jeiDescription() {
        return Component.translatable((String)Translations.Jei.TUNNEL_BORE);
    }
}

