/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory;

import java.util.Collections;
import java.util.List;
import mods.railcraft.gui.widget.AnalogGaugeWidget;
import mods.railcraft.gui.widget.ChargeNetworkUtilizationIndicator;
import mods.railcraft.gui.widget.Gauge;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.inventory.slot.ItemFilterSlot;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.entity.SteamTurbineBlockEntity;
import mods.railcraft.world.module.SteamTurbineModule;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class SteamTurbineMenu
extends RailcraftMenu {
    public static final int GUI_HEIGHT = 140;
    private final AnalogGaugeWidget turbineWidget;
    private final AnalogGaugeWidget chargeWidget;

    public SteamTurbineMenu(int id, Inventory inventory, SteamTurbineBlockEntity steamTurbine) {
        super((MenuType)RailcraftMenuTypes.STEAM_TURBINE.get(), id, inventory.player, steamTurbine::isStillValid);
        ServerLevel level;
        final SteamTurbineModule module = steamTurbine.getSteamTurbineModule();
        Container rotorContainer = module.getRotorContainer();
        this.turbineWidget = new AnalogGaugeWidget(new Gauge(){
            private float clientValue;
            private List<Component> tooltip = Collections.emptyList();
            {
                this.refresh();
            }

            @Override
            public void refresh() {
                this.tooltip = List.of(Component.literal((String)String.format("%.0f%%", (double)this.clientValue * 100.0)));
            }

            @Override
            public List<Component> getTooltip() {
                return this.tooltip;
            }

            @Override
            public float getServerValue() {
                return module.getOperatingRatio();
            }

            @Override
            public float getClientValue() {
                return this.clientValue;
            }

            @Override
            public void setClientValue(float value) {
                this.clientValue = value;
            }
        }, 137, 19, 28, 14, 99, 65);
        this.addWidget(this.turbineWidget);
        Level level2 = steamTurbine.getLevel();
        this.chargeWidget = new AnalogGaugeWidget(new ChargeNetworkUtilizationIndicator(level2 instanceof ServerLevel ? (level = (ServerLevel)level2) : null, steamTurbine.getBlockPos()), 137, 38, 28, 14, 99, 65);
        this.addWidget(this.chargeWidget);
        this.addSlot(new ItemFilterSlot(StackFilter.of((Item)RailcraftItems.TURBINE_ROTOR.get()), rotorContainer, 0, 60, 24).setStackLimit(1));
        this.addInventorySlots(inventory, 140);
    }

    public AnalogGaugeWidget getTurbineWidget() {
        return this.turbineWidget;
    }

    public AnalogGaugeWidget getChargeWidget() {
        return this.chargeWidget;
    }
}

