/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mods.railcraft.api.core.RailcraftFakePlayer;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.item.CartItem;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class MinecartUtil {
    private MinecartUtil() {
    }

    public static double getCartSpeedUncapped(Vec3 deltaMovement) {
        return Math.sqrt(MinecartUtil.getCartSpeedUncappedSquared(deltaMovement));
    }

    public static double getCartSpeedUncappedSquared(Vec3 deltaMovement) {
        return deltaMovement.x() * deltaMovement.x() + deltaMovement.z() * deltaMovement.z();
    }

    public static boolean cartVelocityIsLessThan(AbstractMinecart minecart, float velocity) {
        return MinecartUtil.cartVelocityIsLessThan(minecart.getDeltaMovement(), velocity);
    }

    public static boolean cartVelocityIsLessThan(Vec3 deltaMovement, float velocity) {
        return Math.abs(deltaMovement.x()) < (double)velocity && Math.abs(deltaMovement.z()) < (double)velocity;
    }

    public static void explodeCart(AbstractMinecart cart) {
        if (!cart.isAlive()) {
            return;
        }
        cart.setDeltaMovement(0.0, cart.getDeltaMovement().y(), 0.0);
        if (cart.level().isClientSide()) {
            return;
        }
        MinecartUtil.removePassengers(cart, cart.getX(), cart.getY() + 1.5, cart.getZ());
        cart.level().explode((Entity)cart, cart.getX(), cart.getY(), cart.getZ(), 3.0f, Level.ExplosionInteraction.TNT);
        if (cart.level().getRandom().nextInt(2) == 0) {
            cart.kill();
        }
    }

    public static List<UUID> getMinecartUUIDsAt(Level level, BlockPos pos, float sensitivity) {
        return MinecartUtil.getMinecartUUIDsAt(level, pos.getX(), pos.getY(), pos.getZ(), sensitivity);
    }

    public static List<UUID> getMinecartUUIDsAt(Level level, int x, int y, int z, float sensitivity) {
        sensitivity = Math.min(sensitivity, 0.49f);
        return level.getEntitiesOfClass(AbstractMinecart.class, new AABB((double)((float)x + sensitivity), (double)((float)y + sensitivity), (double)((float)z + sensitivity), (double)((float)(x + 1) - sensitivity), (double)((float)(y + 1) - sensitivity), (double)((float)(z + 1) - sensitivity)), EntitySelector.ENTITY_STILL_ALIVE).stream().map(Entity::getUUID).collect(Collectors.toList());
    }

    public static void removePassengers(AbstractMinecart cart) {
        MinecartUtil.removePassengers(cart, cart.getX(), cart.getY(), cart.getZ());
    }

    public static void removePassengers(AbstractMinecart cart, double x, double y, double z) {
        List passengers = cart.getPassengers();
        cart.ejectPassengers();
        for (Entity entity : passengers) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.setPos(x, y, z);
                continue;
            }
            entity.moveTo(x, y, z, entity.getYRot(), entity.getXRot());
        }
    }

    public static ServerPlayer getFakePlayer(AbstractMinecart cart) {
        return RailcraftFakePlayer.get((ServerLevel)cart.level(), cart.position());
    }

    public static ServerPlayer getFakePlayerWith(AbstractMinecart cart, ItemStack stack) {
        ServerPlayer player = MinecartUtil.getFakePlayer(cart);
        player.setItemInHand(InteractionHand.MAIN_HAND, stack);
        return player;
    }

    public static boolean isInRangeToRenderDist(AbstractMinecart entity, double distance) {
        double range = entity.getBoundingBox().getSize();
        if (Double.isNaN(range)) {
            range = 1.0;
        }
        return distance < (range = range * 64.0 * 4.0) * range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static AbstractMinecart getCartFromUUID(@Nullable Level level, @Nullable UUID id) {
        if (level == null) return null;
        if (id == null) {
            return null;
        }
        if (!(level instanceof ServerLevel)) return MinecartUtil.getClientCartFromUUID(level, id);
        ServerLevel serverLevel = (ServerLevel)level;
        Entity entity = serverLevel.getEntity(id);
        if (!(entity instanceof AbstractMinecart)) return null;
        AbstractMinecart cart = (AbstractMinecart)entity;
        if (!entity.isAlive()) return null;
        AbstractMinecart abstractMinecart = cart;
        return abstractMinecart;
    }

    private static AbstractMinecart getClientCartFromUUID(Level level, UUID id) {
        if (!(level instanceof ClientLevel)) {
            return null;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        for (Entity entity : clientLevel.entitiesForRendering()) {
            if (!(entity instanceof AbstractMinecart)) continue;
            AbstractMinecart abstractMinecart = (AbstractMinecart)entity;
            if (!entity.isAlive() || !entity.getUUID().equals(id)) continue;
            return abstractMinecart;
        }
        return null;
    }

    public static boolean startBoost(AbstractMinecart cart, BlockPos pos, RailShape dir, double startBoost) {
        Level level = cart.level();
        if (dir == RailShape.EAST_WEST) {
            if (Block.canSupportCenter((LevelReader)level, (BlockPos)pos.west(), (Direction)Direction.EAST)) {
                Vec3 motion = cart.getDeltaMovement();
                cart.setDeltaMovement(startBoost, motion.y(), motion.z());
                return true;
            }
            if (Block.canSupportCenter((LevelReader)level, (BlockPos)pos.east(), (Direction)Direction.WEST)) {
                Vec3 motion = cart.getDeltaMovement();
                cart.setDeltaMovement(-startBoost, motion.y(), motion.z());
                return true;
            }
        } else if (dir == RailShape.NORTH_SOUTH) {
            if (Block.canSupportCenter((LevelReader)level, (BlockPos)pos.north(), (Direction)Direction.SOUTH)) {
                Vec3 motion = cart.getDeltaMovement();
                cart.setDeltaMovement(motion.x(), motion.y(), startBoost);
                return true;
            }
            if (Block.canSupportCenter((LevelReader)level, (BlockPos)pos.south(), (Direction)Direction.NORTH)) {
                Vec3 motion = cart.getDeltaMovement();
                cart.setDeltaMovement(motion.x(), motion.y(), -startBoost);
                return true;
            }
        }
        return false;
    }

    public static void smackCart(AbstractMinecart cart, Player smacker, float smackVelocity) {
        MinecartUtil.smackCart(cart, cart, smacker, smackVelocity);
    }

    public static void smackCart(AbstractMinecart respect, AbstractMinecart cart, Player smacker, float smackVelocity) {
        cart.setDeltaMovement(cart.getDeltaMovement().add(Math.copySign((double)smackVelocity, respect.getX() - smacker.getX()), 0.0, Math.copySign((double)smackVelocity, respect.getZ() - smacker.getZ())));
    }

    public static void initCartPos(AbstractMinecart entity, double x, double y, double z) {
        entity.setPos(x, y, z);
        entity.setOldPosAndRot();
        entity.setDeltaMovement(Vec3.ZERO);
    }

    @Nullable
    public static AbstractMinecart placeCart(ItemStack cartItem, ServerLevel level, BlockPos pos) {
        if (cartItem.isEmpty()) {
            return null;
        }
        BlockState blockState = level.getBlockState(pos);
        if (!TrackUtil.isStraightTrackAt((BlockGetter)level, pos)) {
            return null;
        }
        if (EntitySearcher.findMinecarts().at(pos).list((Level)level).isEmpty()) {
            RailShape trackShape = TrackUtil.getTrackDirection((BlockGetter)level, pos, blockState);
            double h = trackShape.isAscending() ? 0.5 : 0.0;
            ItemStack cartStack = cartItem.copy();
            AbstractMinecart cart = null;
            Item item = cartItem.getItem();
            if (item instanceof CartItem) {
                CartItem railcraftCartItem = (CartItem)item;
                cart = railcraftCartItem.getMinecartFactory().createMinecart(cartStack, (double)pos.getX() + 0.5, (double)pos.getY() + 0.0625 + h, (double)pos.getZ() + 0.5, level);
            } else {
                item = cartItem.getItem();
                if (item instanceof MinecartItem) {
                    MinecartItem minecartItem = (MinecartItem)item;
                    cart = AbstractMinecart.createMinecart((ServerLevel)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.0625 + h), (double)((double)pos.getZ() + 0.5), (AbstractMinecart.Type)minecartItem.type, (ItemStack)cartItem, null);
                }
            }
            if (cart == null) {
                return null;
            }
            if (cartStack.has(DataComponents.CUSTOM_NAME)) {
                cart.setCustomName(cartStack.getDisplayName());
            }
            level.addFreshEntity(cart);
            return cart;
        }
        return null;
    }
}

