/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.ContainerSlotAccessor;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import mods.railcraft.util.Predicates;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ContainerMapper
implements Container,
ContainerManipulator<ModifiableSlotAccessor> {
    private final List<ModifiableSlotAccessor> slots;
    private final Container container;
    private boolean checkItems = true;
    private final int start;
    private final int size;
    private int maxStackSize = -1;
    private Predicate<ItemStack> filter = Predicates.alwaysTrue();

    public static ContainerMapper make(Container container) {
        return new ContainerMapper(container, 0, container.getContainerSize());
    }

    public static ContainerMapper make(Container container, int start, int size) {
        return new ContainerMapper(container, start, size);
    }

    public ContainerMapper(Container container, int start, int size) {
        this.slots = ContainerSlotAccessor.createSlots(container, start, start + size).toList();
        this.container = container;
        this.start = start;
        this.size = size;
    }

    public ContainerMapper ignoreItemChecks() {
        this.checkItems = false;
        return this;
    }

    @SafeVarargs
    public final ContainerMapper addFilters(Predicate<ItemStack> ... filters) {
        this.filter = Predicates.and(this.filter, filters);
        return this;
    }

    public Predicate<ItemStack> filter() {
        return this.filter;
    }

    public ContainerMapper withStackSizeLimit(int limit) {
        this.maxStackSize = limit;
        return this;
    }

    public int getContainerSize() {
        return this.size;
    }

    public ItemStack getItem(int slot) {
        this.validSlot(slot);
        return this.container.getItem(this.start + slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        this.validSlot(slot);
        return this.container.removeItem(this.start + slot, amount);
    }

    public void setItem(int slot, ItemStack itemstack) {
        this.validSlot(slot);
        this.container.setItem(this.start + slot, itemstack);
    }

    public int getMaxStackSize() {
        return this.maxStackSize > 0 ? this.maxStackSize : this.container.getMaxStackSize();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        this.validSlot(slot);
        return !this.checkItems || this.filter.test(stack) && this.container.canPlaceItem(this.start + slot, stack);
    }

    @Override
    public Stream<ModifiableSlotAccessor> stream() {
        return this.slots.stream();
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.container.removeItemNoUpdate(slot);
    }

    public void setChanged() {
        this.container.setChanged();
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public void startOpen(Player player) {
        this.container.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.container.stopOpen(player);
    }

    public void clearContent() {
        this.container.clearContent();
    }

    public boolean checkItems() {
        return this.checkItems;
    }

    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    public boolean containsSlot(int absoluteIndex) {
        return absoluteIndex >= this.start && absoluteIndex < this.start + this.size;
    }

    private void validSlot(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new IllegalArgumentException("Slot index out of bounds.");
        }
    }
}

