/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import com.google.common.collect.ForwardingMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.util.ItemStackKey;
import mods.railcraft.util.container.StackFilter;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class ContainerManifest
extends ForwardingMap<ItemStackKey, ManifestEntry> {
    private final Map<ItemStackKey, ManifestEntry> entries = new HashMap<ItemStackKey, ManifestEntry>();

    private ContainerManifest() {
    }

    protected Map<ItemStackKey, ManifestEntry> delegate() {
        return this.entries;
    }

    public int count(ItemStackKey key) {
        ManifestEntry entry = (ManifestEntry)this.get(key);
        if (entry == null) {
            return 0;
        }
        return entry.count();
    }

    public Stream<ItemStack> streamValueStacks() {
        return this.entries.values().stream().flatMap(ManifestEntry::stream);
    }

    public Stream<ItemStack> streamKeyStacks() {
        return this.entries.keySet().stream().map(ItemStackKey::copyStack);
    }

    public List<ItemStack> keyStacks() {
        return this.streamKeyStacks().collect(Collectors.toList());
    }

    private static ManifestEntry compute(ItemStackKey key, @Nullable ManifestEntry entry, ItemStack stack) {
        if (entry == null) {
            entry = new ManifestEntry(key);
        }
        entry.stacks.add(stack.copy());
        return entry;
    }

    public static ContainerManifest create(ContainerManipulator<?> containers) {
        ContainerManifest manifest = new ContainerManifest();
        containers.streamItems().forEach(stack -> {
            ItemStackKey key = ItemStackKey.make(stack);
            manifest.compute(key, (k, v) -> ContainerManifest.compute(k, v, stack));
        });
        return manifest;
    }

    public static ContainerManifest create(ContainerManipulator<?> containers, Collection<ItemStackKey> keys) {
        ContainerManifest manifest = new ContainerManifest();
        for (ItemStackKey filterKey : keys) {
            Predicate<ItemStack> filter = StackFilter.anyMatch(filterKey.itemStack());
            containers.streamItems().filter(filter).forEach(stack -> manifest.compute(filterKey, (k, v) -> ContainerManifest.compute(k, v, stack)));
        }
        return manifest;
    }

    public static ContainerManifest create(Container container, Collection<ItemStackKey> keys) {
        ContainerManifest manifest = new ContainerManifest();
        for (ItemStackKey filterKey : keys) {
            Predicate<ItemStack> filter = StackFilter.anyMatch(filterKey.itemStack());
            IntStream.range(0, container.getContainerSize()).mapToObj(arg_0 -> ((Container)container).getItem(arg_0)).filter(filter).forEach(stack -> manifest.compute(filterKey, (k, v) -> ContainerManifest.compute(k, v, stack)));
        }
        return manifest;
    }

    public static class ManifestEntry {
        private final ItemStackKey key;
        final List<ItemStack> stacks = new ArrayList<ItemStack>();

        public ManifestEntry(ItemStackKey key) {
            this.key = key;
        }

        public ItemStackKey key() {
            return this.key;
        }

        public int count() {
            return this.stacks.stream().mapToInt(ItemStack::getCount).sum();
        }

        public List<ItemStack> stacks() {
            return Collections.unmodifiableList(this.stacks);
        }

        public Stream<ItemStack> stream() {
            return this.stacks.stream();
        }
    }
}

