/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import java.util.Objects;
import java.util.function.Predicate;
import mods.railcraft.util.Predicates;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public enum ModEntitySelector implements Predicate<Entity>
{
    LIVING{
        private final Predicate<Entity> predicate = Predicates.and(Objects::nonNull, EntitySelector.ENTITY_STILL_ALIVE, EntitySelector.NO_SPECTATORS);

        @Override
        public boolean test(Entity entity) {
            return this.predicate.test(entity);
        }
    }
    ,
    KILLABLE{

        @Override
        public boolean test(Entity entity) {
            LivingEntity livingEntity;
            return LIVING.test(entity) && entity.isAttackable() && !(entity.getVehicle() instanceof AbstractMinecart) && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getMaxHealth() < 100.0f;
        }
    }
    ,
    NON_MECHANICAL{

        @Override
        public boolean test(Entity entity) {
            return !entity.onlyOpCanSetNbt();
        }
    };

}

