/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.util.Timer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public final class AdjacentBlockEntityCache {
    private static final int DELAY_MIN = 20;
    private static final int DELAY_MAX = 2400;
    private static final int DELAY_STEP = 2;
    private final Timer[] timer = new Timer[6];
    private final BlockEntity[] cache = new BlockEntity[6];
    private final int[] delay = new int[6];
    private final BlockEntity blockEntity;
    private final Set<ICacheListener> listeners = new LinkedHashSet<ICacheListener>();

    public AdjacentBlockEntityCache(BlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        Arrays.fill(this.delay, 20);
        for (int i = 0; i < this.timer.length; ++i) {
            this.timer[i] = new Timer();
        }
    }

    public void addListener(ICacheListener listener) {
        this.listeners.add(listener);
    }

    @Nullable
    private BlockEntity searchSide(Direction side) {
        return LevelUtil.getBlockEntityWeak(this.blockEntity.getLevel(), this.blockEntity.getBlockPos().relative(side));
    }

    public void refresh() {
        for (Direction side : Direction.values()) {
            this.getTileOnSide(side);
        }
    }

    public void purge() {
        Arrays.fill(this.cache, null);
        this.resetTimers();
        this.listeners.forEach(ICacheListener::purge);
    }

    public void resetTimers() {
        Arrays.fill(this.delay, 20);
        Arrays.stream(this.timer).forEach(Timer::reset);
    }

    protected void setTile(Direction side, @Nullable BlockEntity tile) {
        int s = side.ordinal();
        if (this.cache[s] != tile) {
            this.cache[s] = tile;
            this.changed(side, tile);
        }
    }

    private void changed(Direction side, @Nullable BlockEntity newTile) {
        this.listeners.forEach(l -> l.changed(side, newTile));
    }

    private boolean isInSameChunk(Direction side) {
        BlockPos pos = this.blockEntity.getBlockPos();
        BlockPos sidePos = pos.relative(side);
        return pos.getX() >> 4 == sidePos.getX() >> 4 && pos.getZ() >> 4 == sidePos.getZ() >> 4;
    }

    public Optional<BlockEntity> onSide(Direction side) {
        return Optional.ofNullable(this.getTileOnSide(side));
    }

    @Nullable
    public BlockEntity getTileOnSide(Direction side) {
        if (!this.isInSameChunk(side)) {
            BlockEntity tile = this.searchSide(side);
            this.changed(side, tile);
            return tile;
        }
        int s = side.ordinal();
        if (this.cache[s] != null) {
            if (this.cache[s].isRemoved() || !this.blockEntity.getBlockPos().relative(side).equals((Object)this.cache[s].getBlockPos())) {
                this.setTile(side, null);
            } else {
                return this.cache[s];
            }
        }
        if (this.timer[s].hasTriggered(this.blockEntity.getLevel(), this.delay[s])) {
            this.setTile(side, this.searchSide(side));
            if (this.cache[s] == null) {
                this.incrementDelay(s);
            } else {
                this.delay[s] = 20;
            }
        }
        return this.cache[s];
    }

    private void incrementDelay(int side) {
        int n = side;
        this.delay[n] = this.delay[n] + 2;
        if (this.delay[side] > 2400) {
            this.delay[side] = 2400;
        }
    }

    public List<String> getDebugOutput() {
        ArrayList<String> debug = new ArrayList<String>();
        debug.add("Neighbor Cache: " + Arrays.toString(this.cache));
        return debug;
    }

    public static interface ICacheListener {
        public void changed(Direction var1, @Nullable BlockEntity var2);

        public void purge();
    }
}

