/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.particle;

import com.mojang.serialization.MapCodec;
import mods.railcraft.particle.ChimneyParticleOptions;
import mods.railcraft.particle.ChunkLoaderParticleOptions;
import mods.railcraft.particle.FireSparkParticleOptions;
import mods.railcraft.particle.ForceSpawnParticleOptions;
import mods.railcraft.particle.TuningAuraParticleOptions;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RailcraftParticleTypes {
    private static final DeferredRegister<ParticleType<?>> deferredRegister = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"railcraft");
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> STEAM = deferredRegister.register("steam", () -> new SimpleParticleType(false));
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> SPARK = deferredRegister.register("spark", () -> new SimpleParticleType(false));
    public static final DeferredHolder<ParticleType<?>, ParticleType<FireSparkParticleOptions>> FIRE_SPARK = deferredRegister.register("fire_spark", () -> RailcraftParticleTypes.create(FireSparkParticleOptions.CODEC, FireSparkParticleOptions.STREAM_CODEC));
    public static final DeferredHolder<ParticleType<?>, SimpleParticleType> PUMPKIN = deferredRegister.register("pumpkin", () -> new SimpleParticleType(false));
    public static final DeferredHolder<ParticleType<?>, ParticleType<TuningAuraParticleOptions>> TUNING_AURA = deferredRegister.register("tuning_aura", () -> RailcraftParticleTypes.create(TuningAuraParticleOptions.CODEC, TuningAuraParticleOptions.STREAM_CODEC));
    public static final DeferredHolder<ParticleType<?>, ParticleType<ForceSpawnParticleOptions>> FORCE_SPAWN = deferredRegister.register("force_spawn", () -> RailcraftParticleTypes.create(ForceSpawnParticleOptions.CODEC, ForceSpawnParticleOptions.STREAM_CODEC));
    public static final DeferredHolder<ParticleType<?>, ParticleType<ChimneyParticleOptions>> CHIMNEY = deferredRegister.register("chimney", () -> RailcraftParticleTypes.create(ChimneyParticleOptions.CODEC, ChimneyParticleOptions.STREAM_CODEC));
    public static final DeferredHolder<ParticleType<?>, ParticleType<ChunkLoaderParticleOptions>> CHUNK_LOADER = deferredRegister.register("chunk_loader", () -> RailcraftParticleTypes.create(ChunkLoaderParticleOptions.CODEC, ChunkLoaderParticleOptions.STREAM_CODEC));

    public static void register(IEventBus modEventBus) {
        deferredRegister.register(modEventBus);
    }

    private static <T extends ParticleOptions> ParticleType<T> create(final MapCodec<T> codec, final StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        return new ParticleType<T>(false){

            public MapCodec<T> codec() {
                return codec;
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return streamCodec;
            }
        };
    }
}

