/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetLocomotiveByKeyMessage(LocomotiveKeyBinding keyBinding) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetLocomotiveByKeyMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("set_locomotive_by_key"));
    public static final StreamCodec<FriendlyByteBuf, SetLocomotiveByKeyMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(LocomotiveKeyBinding.class), SetLocomotiveByKeyMessage::keyBinding, SetLocomotiveByKeyMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetLocomotiveByKeyMessage message, IPayloadContext context) {
        Player player = context.player();
        Entity entity = player.getVehicle();
        if (!(entity instanceof Minecart)) {
            return;
        }
        Minecart minecart = (Minecart)entity;
        switch (message.keyBinding.ordinal()) {
            case 0: {
                Locomotive.applyAction(player, (AbstractMinecart)minecart, false, loco -> loco.setReverse(!loco.isReverse()));
                break;
            }
            case 1: {
                Locomotive.applyAction(player, (AbstractMinecart)minecart, false, Locomotive::increaseSpeed);
                break;
            }
            case 2: {
                Locomotive.applyAction(player, (AbstractMinecart)minecart, false, Locomotive::decreaseSpeed);
                break;
            }
            case 4: {
                Locomotive.applyAction(player, (AbstractMinecart)minecart, false, Locomotive::whistle);
                break;
            }
            case 3: {
                Locomotive.applyAction(player, (AbstractMinecart)minecart, false, loco -> {
                    Locomotive.Mode mode = loco.getMode();
                    while (!loco.isAllowedMode(mode = mode.next())) {
                    }
                    loco.setMode(mode);
                });
            }
        }
    }

    public static enum LocomotiveKeyBinding {
        REVERSE,
        FASTER,
        SLOWER,
        MODE_CHANGE,
        WHISTLE;

    }
}

