/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.integrations.emi.RailcraftEmiPlugin;
import mods.railcraft.world.item.crafting.CrusherRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

public class CrusherEmiRecipe
extends BasicEmiRecipe {
    private static final int WIDTH = 144;
    private static final int HEIGHT = 54;
    private static final ResourceLocation BACKGROUND = RailcraftConstants.rl("textures/gui/container/crusher.png");
    private final CrusherRecipe recipe;

    public CrusherEmiRecipe(RecipeHolder<CrusherRecipe> recipe) {
        super(RailcraftEmiPlugin.CRUSHING_CATEGORY, recipe.id(), 144, 54);
        this.recipe = (CrusherRecipe)recipe.value();
        this.inputs.add(EmiIngredient.of((Ingredient)((Ingredient)this.recipe.getIngredients().getFirst())));
        this.recipe.getProbabilityOutputs().stream().map(CrusherRecipe.CrusherOutput::getOutput).map(EmiStack::of).forEach(this.outputs::add);
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, this.width, this.height, 0, 171);
        EmiTexture crushingTexture = new EmiTexture(BACKGROUND, 144, 171, 29, 53);
        widgets.addAnimatedTexture(crushingTexture, 58, 0, 1000 * this.recipe.getProcessTime() / 20, true, false, false);
        widgets.addSlot((EmiIngredient)this.inputs.getFirst(), 18, 18);
        List<CrusherRecipe.CrusherOutput> outputs = this.recipe.getProbabilityOutputs();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                ItemStack itemStack = ItemStack.EMPTY;
                if (outputs.size() > index - 1) {
                    itemStack = outputs.get(index - 1).getOutput();
                }
                if (itemStack.isEmpty()) {
                    widgets.addSlot(90 + x * 18, y * 18);
                    continue;
                }
                widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)itemStack), 90 + x * 18, y * 18).appendTooltip(() -> {
                    double probability = ((CrusherRecipe.CrusherOutput)outputs.get(index - 1)).probability() * 100.0;
                    MutableComponent probText = Component.translatable((String)Translations.Jei.CRUSHER_TIP, (Object[])new Object[]{probability}).withStyle(ChatFormatting.GRAY);
                    return EmiTooltipComponents.of((Component)probText);
                }).recipeContext((EmiRecipe)this);
            }
        }
    }
}

