/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.gui.widget;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.gui.widget.Gauge;
import mods.railcraft.util.HumanReadableNumberFormatter;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyStorageBatteryIndicator
implements Gauge {
    private float charge;
    private final IEnergyStorage battery;
    private final List<Component> tooltip = new ArrayList<Component>(2);

    public EnergyStorageBatteryIndicator(IEnergyStorage battery) {
        this.battery = battery;
    }

    @Override
    public void refresh() {
        int capacity = this.battery.getMaxEnergyStored();
        float chargeLevel = this.charge * 100.0f;
        float energyStorage = this.charge * (float)capacity;
        this.tooltip.clear();
        this.tooltip.add((Component)Component.translatable((String)Translations.Tips.PERCENTAGE).withStyle(ChatFormatting.GREEN).append(CommonComponents.SPACE).append((Component)Component.literal((String)String.format("%.0f%%", Float.valueOf(chargeLevel))).withStyle(ChatFormatting.WHITE)));
        this.tooltip.add((Component)Component.translatable((String)Translations.Tips.ENERGY).withStyle(ChatFormatting.GREEN).append(CommonComponents.SPACE).append((Component)Component.literal((String)String.format("%sFE / %sFE", HumanReadableNumberFormatter.format(energyStorage), HumanReadableNumberFormatter.format(capacity))).withStyle(ChatFormatting.WHITE)));
    }

    @Override
    public List<Component> getTooltip() {
        return this.tooltip;
    }

    @Override
    public float getServerValue() {
        int energyStored = this.battery.getEnergyStored();
        int capacity = this.battery.getMaxEnergyStored();
        return (float)energyStored / (float)capacity;
    }

    @Override
    public float getClientValue() {
        return this.charge;
    }

    @Override
    public void setClientValue(float value) {
        this.charge = value;
    }
}

