/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.model.DeformableMinecartModel;
import mods.railcraft.client.model.MaintenanceLampModel;
import mods.railcraft.client.model.MaintenanceModel;
import mods.railcraft.client.model.RailcraftModelLayers;
import mods.railcraft.client.renderer.entity.cart.ContentsMinecartRenderer;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public abstract class MaintenanceMinecartRenderer
extends ContentsMinecartRenderer<MaintenanceMinecart> {
    private static final ResourceLocation LAMP_ON_TEX = RailcraftConstants.rl("textures/entity/minecart/maintenance_lamp_on.png");
    private static final ResourceLocation LAMP_OFF_TEX = RailcraftConstants.rl("textures/entity/minecart/maintenance_lamp_off.png");
    private static final ResourceLocation LAMP_DISABLED_TEX = RailcraftConstants.rl("textures/entity/minecart/maintenance_lamp_disabled.png");
    private final ResourceLocation maintenanceTextureLocation;
    private final MinecartModel<MaintenanceMinecart> bodyModel;
    private final DeformableMinecartModel<MaintenanceMinecart> snowModel;
    private final Model maintenanceModel;
    private final Model lampModel;

    public MaintenanceMinecartRenderer(EntityRendererProvider.Context context, ResourceLocation maintenanceTextureLocation) {
        super(context);
        this.maintenanceTextureLocation = maintenanceTextureLocation;
        this.bodyModel = new MinecartModel(context.bakeLayer(ModelLayers.MINECART));
        this.snowModel = new DeformableMinecartModel(context.bakeLayer(RailcraftModelLayers.MINECART_SNOW));
        this.maintenanceModel = new MaintenanceModel(context.bakeLayer(RailcraftModelLayers.MAINTENANCE));
        this.lampModel = new MaintenanceLampModel(context.bakeLayer(RailcraftModelLayers.MAINTENANCE_LAMP));
    }

    @Override
    public void renderContents(MaintenanceMinecart cart, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int color) {
        VertexConsumer maintenanceVertexConsumer = bufferSource.getBuffer(this.maintenanceModel.renderType(this.maintenanceTextureLocation));
        this.maintenanceModel.renderToBuffer(poseStack, maintenanceVertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        poseStack.pushPose();
        boolean blinking = cart.isBlinking();
        ResourceLocation textureLocation = blinking ? LAMP_ON_TEX : (cart.mode() == MaintenanceMinecart.Mode.OFF ? LAMP_DISABLED_TEX : LAMP_OFF_TEX);
        VertexConsumer lampVertexConsumer = bufferSource.getBuffer(this.lampModel.renderType(textureLocation));
        this.lampModel.renderToBuffer(poseStack, lampVertexConsumer, blinking ? 0xF000F0 : packedLight, OverlayTexture.NO_OVERLAY, color);
        poseStack.popPose();
    }

    @Override
    protected EntityModel<? super MaintenanceMinecart> getBodyModel(MaintenanceMinecart cart) {
        return this.bodyModel;
    }

    @Override
    protected EntityModel<? super MaintenanceMinecart> getSnowModel(MaintenanceMinecart cart) {
        return this.snowModel;
    }
}

